% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network-tools.r
\name{jtt}
\alias{jtt}
\title{Number of JTTs in a graph}
\usage{
jtt(data, from_id, to_id)
}
\arguments{
\item{data}{data set}

\item{from_id}{name of the variable of edge tails}

\item{to_id}{name of the variable of edge heads}
}
\description{
Number of jumping transitive triplets (JTT) in a graph. A JTT between three nodes i,j,
and k is defined as the situation that when there is a (directed) edge from i to j and an
edge from j to k there is also a direct edge from i to k.
In an undirected situation we can think of any undirected edge as two directed edges between the two nodes involved.
}
\examples{
data(blood)
ggplot(data= blood$edges) + geom_net(aes(from_id=from, to_id=to), directed=TRUE) + theme_net()
jtt(blood$edges, "from", "to")
# this number is very high compared to the overall number of edges that are not self-loops
nrow(subset(blood$edges, from != to))
}

