% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\docType{methods}
\name{check}
\alias{check}
\alias{check,character-method}
\alias{check,geojob-method}
\title{Check status of processing request}
\usage{
check(.Object)

\S4method{check}{geojob}(.Object)

\S4method{check}{character}(.Object)
}
\arguments{
\item{.Object}{a \linkS4class{geojob} object with an active GDP process request, 
or a \code{character} URL of an existing job}
}
\value{
\code{process}, a list containing
\code{status} and \code{URL}.
}
\description{
Check status of processing request
}
\details{
check is a method for checking the process status of an active (executed)
\linkS4class{geojob} object. The method returns \code{process}, which is a list containing
two fields: \code{status} and \code{URL}. If the \linkS4class{geojob} object has not been executed
(see \code{\link{start}}), this method returns \code{status}='none' and \code{URL}=NULL.
}
\examples{
gj <- geojob() # create geojob object
check(gj) # no process for empty geojob object
}
\author{
Jordan S. Read
}
\seealso{
\code{\link{start}}
}

