% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acs_5yr_selection.R
\name{as_acs_5yr_topic}
\alias{as_acs_5yr_topic}
\alias{as_acs_5yr_topic.acs_5yr}
\title{As ACS census topic (report group)}
\usage{
as_acs_5yr_topic(ac, area, years, topic)

\method{as_acs_5yr_topic}{acs_5yr}(ac, area, years = NULL, topic = NULL)
}
\arguments{
\item{ac}{An \code{acs_5yr} object.}

\item{area}{A string, area name.}

\item{years}{A vector, year number.}

\item{topic}{A vector, topic name.}
}
\value{
An \code{acs_5yr_topic} object.
}
\description{
Gets an ACS census topic object (report group) for the given years of the
Demographic and Economic Areas that are downloaded and unzipped, available to
be queried.
}
\details{
If no year is indicated, all available years are taken. If no topic is given,
the first one that appears in the files is taken.
}
\examples{

\donttest{
dir <- tempdir()
source_dir <- system.file("extdata/acs_5yr", package = "geogenr")
files <- list.files(source_dir, "*.zip", full.names = TRUE)
file.copy(from = files, to = dir, overwrite = TRUE)
ac <- acs_5yr(dir)

files <- ac |>
  unzip_files()

anrc_2021_x01 <- ac |>
  as_acs_5yr_topic("Alaska Native Regional Corporation",
                   2021,
                   "X01 Age And Sex")

anrc_2021_2022_x01_x07 <- ac |>
  as_acs_5yr_topic("Alaska Native Regional Corporation",
                   topic = c("X01 Age And Sex", "X07 Migration"))
}
}
\seealso{
Other data selection functions: 
\code{\link{get_available_area_topics}()},
\code{\link{get_available_area_years}()},
\code{\link{get_available_areas}()},
\code{\link{get_geo_attribute_names}()},
\code{\link{get_geo_layer.acs_5yr_geo}()},
\code{\link{get_names_of_other_topics}()},
\code{\link{get_report_names}()},
\code{\link{get_subreport_names}()},
\code{\link{get_topic_name}()},
\code{\link{select_report}()},
\code{\link{select_subreport}()},
\code{\link{select_topic}()}
}
\concept{data selection functions}
