% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uscb_layer_get_layer.R
\name{get_layer}
\alias{get_layer}
\alias{get_layer.uscb_layer}
\title{Get layer}
\usage{
get_layer(ul, layer_name)

\method{get_layer}{uscb_layer}(ul, layer_name)
}
\arguments{
\item{ul}{A \code{uscb_layer} object.}

\item{layer_name}{A layer name.}
}
\value{
A \code{uscb_layer} object.
}
\description{
Get a layer to interpret its variables. Refines the content of the object.
}
\examples{
library(tidyr)

folder <- system.file("extdata", package = "geogenr")
folder <- stringr::str_replace_all(paste(folder, "/", ""), " ", "")
ua <- uscb_acs_5ye(folder = folder)
sa <- ua \%>\% get_statistical_areas()
# sa[6]
# [1] "New England City and Town Area Division"
ul <- uscb_layer(uscb_acs_metadata, ua = ua, geodatabase = sa[6], year = 2015)
layers <- ul \%>\% get_layer_names()

# layers[3]
# [1] "X02_RACE"
ul <- ul \%>\% get_layer(layers[3])

}
\seealso{


Other data selection functions: 
\code{\link{get_layer_group_names}()},
\code{\link{get_layer_group}()},
\code{\link{get_layer_names}()},
\code{\link{uscb_folder}()},
\code{\link{uscb_layer}()}
}
\concept{data selection functions}
