% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_municipalities.R
\name{get_municipalities}
\alias{get_municipalities}
\title{Get Finnish municipality (multi)polygons for different years and/or scales.}
\usage{
get_municipalities(year = 2021, scale = 4500)
}
\arguments{
\item{year}{A numeric for year of the administerative borders. Available are
2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020 and 2021.}

\item{scale}{A scale or resolution of the shape. Two options: \code{1000}
equals 1:1 000 000 and \code{4500} equals 1:4 500 000.}
}
\value{
sf object
}
\description{
Thin wrapper around Finnish zip code areas provided by
\href{https://www.stat.fi/org/avoindata/paikkatietoaineistot/kuntapohjaiset_tilastointialueet_en.html}{Statistic Finland}.
}
\examples{
 \dontrun{
 f <- get_municipalities(year=2016, scale = 4500)
 plot(f)
 }

}
\author{
Markus Kainu \href{mailto:markus.kainu@kela.fi}{markus.kainu@kela.fi}, Joona Lehtomäki \href{mailto:joona.lehtomaki@iki.fi}{joona.lehtomaki@iki.fi}
}
