% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodist-package.r, R/geodist.R
\docType{package}
\name{geodist}
\alias{geodist}
\alias{geodist-package}
\title{geodist.}
\usage{
geodist(x, y, sequential = FALSE, pad = FALSE, measure = "cheap")
}
\arguments{
\item{x}{Rectangular object (matrix, \code{data.frame}, \pkg{tibble},
whatever) containing longitude and latitude coordinates.}

\item{y}{Optional second object which, if passed, results in distances
calculated between each object in \code{x} and each in \code{y}.}

\item{sequential}{If \code{TRUE}, calculate (vector of) distances
sequentially along \code{x} (when no \code{y} is passed), otherwise calculate
matrix of pairwise distances between all points.}

\item{pad}{If \code{sequential = TRUE} values are padded with initial
\code{NA} to return \code{n} values for input with \code{n} rows, otherwise
return \code{n - 1} values.}

\item{measure}{One of "haversine" "vincenty", "geodesic", or "cheap"
specifying desired method of geodesic distance calculation; see Notes.}
}
\value{
If only \code{x} passed and \code{sequential = FALSE}, a square
symmetric matrix containing distances between all items in \code{x}; If only
\code{x} passed and \code{sequential = TRUE}, a vector of sequential
distances between rows of \code{x}; otherwise if \code{y} is passed, a matrix
of \code{nrow(x)} rows and \code{nrow(y)} columns.
}
\description{
Convert one or two rectangular objects containing lon-lat coordinates into
vector or matrix of geodesic distances.
}
\note{
\code{measure = "cheap"} denotes the mapbox cheap ruler
\url{https://github.com/mapbox/cheap-ruler-cpp}; \code{measure = "geodetic"}
denotes the very accurate geodetic methods given in Kearney (2013)
"Algorithms for geodesics" J Geod 87:43-55, and as provided by the 
code{sf::st_dist()} function.
}
\examples{
n <- 50
x <- cbind (-10 + 20 * runif (n), -10 + 20 * runif (n))
y <- cbind (-10 + 20 * runif (2 * n), -10 + 20 * runif (2 * n))
colnames (x) <- colnames (y) <- c ("x", "y")
d0 <- geodist (x) # A 50-by-50 matrix
d1 <- geodist (x, y) # A 50-by-100 matrix
d2 <- geodist (x, sequential = TRUE) # Vector of length 49
d2 <- geodist (x, sequential = TRUE, pad = TRUE) # Vector of length 50
d0_2 <- geodist (x, measure = "geodesic") # nanometre-accurate version of d0
}
