% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_metro_area.R
\name{read_metro_area}
\alias{read_metro_area}
\title{Download spatial data of official metropolitan areas in Brazil}
\usage{
read_metro_area(year = 2018, simplified = TRUE, showProgress = TRUE)
}
\arguments{
\item{year}{Numeric. Year of the data in YYYY format. Defaults to \code{2018}.}

\item{simplified}{Logic \code{FALSE} or \code{TRUE}, indicating whether the function
should return the data set with 'original' spatial resolution or a data set
with 'simplified' geometry. Defaults to \code{TRUE}. For spatial analysis and
statistics users should set \code{simplified = FALSE}. Borders have been
simplified by removing vertices of borders using \verb{st_simplify\{sf\}} preserving
topology with a \code{dTolerance} of 100.}

\item{showProgress}{Logical. Defaults to \code{TRUE} display progress bar.}
}
\value{
An \verb{"sf" "data.frame"} object
}
\description{
The function returns the shapes of municipalities grouped by their respective
metro areas. Metropolitan areas are created by each state in Brazil. The data
set includes the municipalities that belong to all metropolitan areas in the
country according to state legislation in each year. Original data were
generated by Institute of Geography. Data at scale 1:250,000, using Geodetic
reference system "SIRGAS2000" and CRS(4674).
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Read all official metropolitan areas for a given year
  m <- read_metro_area(2005)

  m <- read_metro_area(2018)
\dontshow{\}) # examplesIf}
}
\seealso{
Other area functions: 
\code{\link{read_amazon}()},
\code{\link{read_biomes}()},
\code{\link{read_capitals}()},
\code{\link{read_comparable_areas}()},
\code{\link{read_country}()},
\code{\link{read_disaster_risk_area}()},
\code{\link{read_health_facilities}()},
\code{\link{read_health_region}()},
\code{\link{read_immediate_region}()},
\code{\link{read_indigenous_land}()},
\code{\link{read_intermediate_region}()},
\code{\link{read_meso_region}()},
\code{\link{read_micro_region}()},
\code{\link{read_municipal_seat}()},
\code{\link{read_municipality}()},
\code{\link{read_neighborhood}()},
\code{\link{read_pop_arrangements}()},
\code{\link{read_region}()},
\code{\link{read_schools}()},
\code{\link{read_semiarid}()},
\code{\link{read_state}()},
\code{\link{read_statistical_grid}()},
\code{\link{read_urban_area}()},
\code{\link{read_urban_concentrations}()},
\code{\link{read_weighting_area}()}
}
\concept{area functions}
