% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addobs.r
\name{addobs}
\alias{addobs}
\title{add observations to the data set}
\usage{
addobs(obs)
}
\arguments{
\item{obs}{one of two possible input types:
\itemize{
\item An R data frame with the same columns as the current dataset.
\item A comma-separated string in the following format: "var1=1,var2=2,var3=3" which inputs a single observation.
}}
}
\value{
returns NULL, invisibly
}
\description{
Add observations to the data set, similar in functionality to Stata's append command
}
\examples{
library(plm)
data(Produc)
use(Produc, clear=TRUE)
keepvar("state year emp unemp")
addobs("state='Puerto Rico',year=1990,emp=100,unemp=5")
listif()
df <- data.frame(state=rep("Puerto Rico", times=2), year=1991:1992,emp=c(102,104),unemp=c(4.9,5.1))
addobs(df)
listif()
}
