% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand_gen.R
\name{rlaplace_truncated}
\alias{rlaplace_truncated}
\title{Generates laplace variables truncated to a finite union of intervals.}
\usage{
rlaplace_truncated(n, lefts, rights, m = 0, s = 1)
}
\arguments{
\item{n}{An integer, the number of samples to return.}

\item{lefts}{A vector of numbers, must have the same length as \code{rights}. A non-empty vector of numbers (may contain \code{-Inf}), the left endpoints of a domain defined as a union of intervals. It is required that \code{lefts[i] <= rights[i] <= lefts[j]} for any \code{i < j}.}

\item{rights}{A vector of numbers, must have the same length as \code{lefts}. A non-empty vector of numbers (may contain \code{Inf}), the right endpoints of a domain defined as a union of intervals. It is required that \code{lefts[i] <= rights[i] <= lefts[j]} for any \code{i < j}.}

\item{m}{A number, the location parameter of the laplace distributionn.}

\item{s}{A number, the scale/dispersion parameter of the laplace distribution.}
}
\value{
\code{n} random variables from the truncated laplace distribution.
}
\description{
Generates laplace variables truncated to a finite union of intervals.
}
\details{
Returns \code{n} random variables from the truncated laplace distribution with density proportional to \eqn{\exp(-|x-m|/s)}{exp(-|x-m|/s)} truncated to the domain defined by the union of [\code{lefts[i]}, \code{rights[i]}].
}
\examples{
hist(rlaplace_truncated(1e4, -Inf, Inf), breaks=200)
hist(rlaplace_truncated(1e4, c(0, 5), c(2, Inf), m=2, s=3), breaks=200)
hist(rlaplace_truncated(1e4, c(-Inf, 0, 3), c(-3, 1, 12), m=8, s=4), breaks=200)
hist(rlaplace_truncated(1e4, c(-5, 0), c(-2, 2), s=0.8), breaks=200)
hist(rlaplace_truncated(1e4, c(-10, 1), c(-7, 10), m=-4), breaks=200)
hist(rlaplace_truncated(1e4, c(-Inf, 100), c(-100, Inf), m=100), breaks=200)
hist(rlaplace_truncated(1e4, c(-Inf, 100), c(-100, Inf), m=-100), breaks=200)
hist(rlaplace_truncated(1e4, c(-100, -90), c(-95, -85), s=2), breaks=200)
}
