% Generated by roxygen2 (4.0.2): do not edit by hand
\name{summary.xtree.reg}
\alias{summary.xtree.reg}
\title{Summary function for the Pathmox Segmentation Trees: linaer regression and LAD}
\usage{
\method{summary}{xtree.reg}(object, ...)
}
\arguments{
\item{object}{An object of class \code{"xtree.reg"}.}

\item{\dots}{Further arguments are ignored.}
}
\description{
The function \code{summary.xtree.reg} returns the most important results obtained
by the function \code{reg.pathmox}. In order, it provides the parameters algorithm (
threshold significance,node size limit,tree depth level and the method used for the
split partition), the basic characteristics of the tree (deep and number of terminal
nodes), the basic characteristics of the nodes and the F-global and F-coefficients
results. For the test results the significance level is indicated.
}
\examples{
\dontrun{
#example of LM in alumni satisfaction

data(fibtelereg)

segvar= fibtelereg[,2:11]

data.fib= fibtelereg[,12:18]

segvar$Age 		= factor(segvar$Age, ordered=T)
segvar$Salary 	= factor(segvar$Salary,
		levels=c("<18k","25k","35k","45k",">45k"), ordered=T)
segvar$Accgrade = factor(segvar$Accgrade,
		levels=c("accnote<7","7-8accnote","accnote>8"), ordered=T)
segvar$Grade 	= factor(segvar$Grade,
		levels=c("<6.5note","6.5-7note","7-7.5note",">7.5note"), ordered=T)

fib.reg.pathmox=reg.pathmox(Satisfact~.,data=data.fib,segvar,
		signif=0.05,deep=2,method="lm",size=0.15)

 summary(fib.reg.pathmox)

}
}
\author{
Giuseppe Lamberti
}
\references{
Lamberti, G. (2014) \emph{Modeling with Heterogeneity.} PhD Dissertation.


\code{\link{summary.xtree.pls}}, \code{\link{reg.pathmox}}.
}

