% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot.xtree.reg}
\alias{plot.xtree.reg}
\title{Plot function for the Pathmox Segmentation Trees: linaer regression and LAD}
\usage{
\method{plot}{xtree.reg}(x, root.col = "grey", node.col = "orange",
  leaf.col = "green2", shadow.size = 0.003, node.shadow = "red",
  leaf.shadow = "darkgreen", cex = 0.7, seg.col = "blue3", lwd = 1,
  show.pval = TRUE, pval.col = "blue", main = NULL, cex.main = 1, ...)
}
\arguments{
\item{x}{An object of class \code{"xtree.reg"} returned by
\code{\link{reg.pathmox}}}

\item{root.col}{Fill color of root node.}

\item{node.col}{Fill color of child nodes.}

\item{leaf.col}{Fill color of col.}

\item{shadow.size}{Relative size of shadows.}

\item{node.shadow}{Color of shadow of child nodes.}

\item{leaf.shadow}{Color of shadow of leaf nodes.}

\item{cex}{A numerical value indicating the magnification to be used for
plotting text.}

\item{seg.col}{The color to be used for the labels of the segmentation
variables.}

\item{lwd}{The line width, a positive number, defaulting to 1.}

\item{show.pval}{Logical value indicating whether the p-values should be
plotted.}

\item{pval.col}{The color to be used for the labels of the p-values.}

\item{main}{A main title for the plot.}

\item{cex.main}{The magnification to be used for the main title.}

\item{\dots}{Further arguments are ignored.}
}
\description{
The function \code{plot.xtree.reg} allows to drow PATHMOX tree for linear and LAD
regression
}
\examples{
\dontrun{
 # example of LM in alumni satisfaction

data(fibtelereg)

segvar= datafib.reg[,2:11]

data.fib=datafib.reg[,12:18]

segvar$Age 		= factor(segvar$Age, ordered=T)
segvar$Salary 	= factor(segvar$Salary,
		levels=c("<18k","25k","35k","45k",">45k"), ordered=T)
segvar$Accgrade = factor(segvar$Accgrade,
		levels=c("accnote<7","7-8accnote","accnote>8"), ordered=T)
segvar$Grade 	= factor(segvar$Grade,
		levels=c("<6.5note","6.5-7note","7-7.5note",">7.5note"), ordered=T)

fib.reg.pathmox=reg.pathmox(Satisfact~.,data=data.fib,segvar,
			signif=0.05,deep=2,method="lm",size=0.15,df="mod1")

plot(fib.reg.pathmox)

}
}

