% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_genius}
\alias{search_genius}
\title{Search documents hosted on Genius}
\usage{
search_genius(search_term, n_results = 10, access_token = genius_token())
}
\arguments{
\item{search_term}{A character string to search for}

\item{n_results}{Maximum no. of search results to return}

\item{access_token}{Genius' client access token, defaults to \code{genius_token}}
}
\value{
a \code{genius_resource} object that contains the extracted content from the request,
the original JSON response object and the request path.
}
\description{
The Genius API lets you search hosted content (all songs). Use \code{search_genius()}
to return hits on for a given search term, in full.
}
\examples{
\dontrun{
search_genius(search_term = "Lil", n_results = 100)
}
}
\seealso{
Other search: 
\code{\link{search_artist}()},
\code{\link{search_song}()}
}
\concept{search}
