% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/songs.R
\name{get_song}
\alias{get_song}
\title{Retrieve metadata for a song}
\usage{
get_song(song_id, access_token = genius_token())
}
\arguments{
\item{song_id}{ID of the song (\code{song_id} within an object returned by
\code{\link{search_song}})}

\item{access_token}{Genius' client access token, defaults to \code{genius_token}}
}
\value{
a \code{genius_song} object that contains the extracted content from the request,
the original JSON response object and the request path.
}
\description{
The Genius API lets you return data for a specific song, given a song ID.
\code{get_song} returns this data in full.
}
\examples{
\dontrun{
get_song(song_id = 3039923)
}
}
\seealso{
See \code{\link{get_song_df}} to return a tidy data frame.

Other song: 
\code{\link{get_song_df}()},
\code{\link{tidy_album_performances}()},
\code{\link{tidy_song_performances}()},
\code{\link{tidy_song_producers}()},
\code{\link{tidy_song_relationships}()},
\code{\link{tidy_song_writers}()}
}
\concept{song}
