% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genius_lyrics.R
\name{genius_lyrics}
\alias{genius_lyrics}
\title{Retrieve song lyrics from Genius.com}
\usage{
genius_lyrics(artist = NULL, song = NULL, info = "title")
}
\arguments{
\item{artist}{The quoted name of the artist. Spelling matters, capitalization does not.}

\item{song}{The quoted name of the song. Spelling matters, capitalization does not.}

\item{info}{Default \code{"title"}, returns the track title. Set to \code{"simple"} for only lyrics, \code{"artist"} for the lyrics and artist, \code{"features"} for song element and the artist of that element,  \code{"all"} to return artist, track, line, lyric, element, and element artist.}
}
\description{
Retrieve the lyrics of a song with supplied artist and song name.
}
\examples{
\donttest{
# genius_lyrics(artist = "Margaret Glaspy", song = "Memory Street")
# genius_lyrics(artist = "Kendrick Lamar", song = "Money Trees")
# genius_lyrics("JMSN", "Drinkin'")
}
}
