% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abs_stdapd.R
\name{abs_stdapd}
\alias{abs_stdapd}
\title{Absolute values of gradients (apd's) of kernel regressions of x on y when
both x and y are standardized.}
\usage{
abs_stdapd(x, y)
}
\arguments{
\item{x}{{vector of data on the dependent variable}}

\item{y}{{data on the regressors which can be a matrix}}
}
\value{
Absolute values of kernel regression gradients are returned after
standardizing the data on both sides so that the magnitudes of amorphous
partial derivatives (apd's) are comparable between regression of x on y on
the one hand and regression of y on x on the other.
}
\description{
1) standardize the data to force mean zero and variance unity, 2) kernel
regress x on y, with the option `gradients = TRUE' and finally 3) compute
the absolute values of gradients
}
\details{
The first argument is assumed to be the dependent variable.  If
\code{abs_stdapd(x,y)} is used, you are regressing x on y (not the usual y
on x). The regressors can be a matrix with 2 or more columns. The missing values
are suitably ignored by the standardization.
}
\examples{
\dontrun{
set.seed(330)
x=sample(20:50)
y=sample(20:50)
abs_stdapd(x,y)
}
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\keyword{apd}
\keyword{gradients}
\keyword{kern}
\keyword{regression}
