% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Genepop.R
\name{clean_workdir}
\alias{clean_workdir}
\title{Removing files created by Genepop}
\usage{
clean_workdir(
  otherfiles = NULL,
  path = ".",
  suffixes = c("GRA", "ISO", "MIG", "PRI", "DAT", "DG", "DIV", "D", "DIS", "FST", "NUL",
    "RHO", "2G2", "G", "GE", "GE2", "INF", "MSD", "TAB", "ST2"),
  in. = TRUE,
  cmdline = TRUE
)
}
\arguments{
\item{otherfiles}{Character vector(s): one or more names of files to be removed and not matched by the other arguments (such as the input file, or some output files not identified by their suffix, as shown in the Example).}

\item{path}{character vector: path from where files should be removed.}

\item{suffixes}{Character vector(s): suffixes of files to be removed (useful for output files with readily identifiable suffixes).}

\item{in.}{boolean: whether to remove the \code{fichier.in} file created by Genepop.}

\item{cmdline}{boolean: whether to remove the \code{cmdline.txt} file created by Genepop.}
}
\description{
This removes \dQuote{temporary files} created by Genepop, but also output files, so it should be used only when one no longer needs the latter files. This function asumes that the input file name contains only alphanumeric, dot, or underscore characters.
}
\examples{
# Removing files possibly written by other examples in the documentation:
clean_workdir(otherfiles=c("sample.txt", "Dsample.txt", "w2.txt", 
"PEL1600withCoord.txt", "Rhesus.txt", "structest.txt"))
}
