% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genInfo.R
\name{genInfo}
\alias{genInfo}
\title{Get gene related information}
\usage{
genInfo(
  id = NULL,
  org = "hs",
  unique = FALSE,
  keepNA = TRUE,
  hgVersion = "v38"
)
}
\arguments{
\item{id}{Gene id (symbol, ensembl or entrez id) or uniprot id. If this argument is NULL, return all gene info.}

\item{org}{Latin organism shortname from `ensOrg_name`. Default is human.}

\item{unique}{Logical, if one-to-many mapping occurs, only keep one record with fewest NA. Default is FALSE.}

\item{keepNA}{If some id has no match at all, keep it or not. Default is TRUE.}

\item{hgVersion}{Select human genome build version from "v38" (default) and "v19".}
}
\value{
A `data.frame`.
}
\description{
Get gene related information
}
\examples{
\donttest{
# example1: input list with fake id and one-to-many mapping id
x <- genInfo(id = c(
  "MCM10", "CDC20", "S100A9", "MMP1", "BCC7",
  "FAKEID", "TP53", "HBD", "NUDT10"
))

# example2: statistics of human gene biotypes
genInfo(org = "hs") \%>\%
  {
    table(.$gene_biotype)
  }

# example3: use hg19 data
x <- genInfo(id = c("TP53","BCC7"), hgVersion = "v19")

# example4: search genes with case-insensitive
x <- genInfo(id = c("tp53","nc886","FAke","EZh2"), org = "hs", unique = TRUE)
}

}
