% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transf-tsTransform.R
\name{tsTransform}
\alias{tsTransform}
\title{Transforms a list of MCMC chains into a list of data.frames using the TS transformation}
\usage{
tsTransform(
  mhDraws,
  distance,
  minDist = 0,
  fuzzy = FALSE,
  fuzzyDist = 1,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{mhDraws}{List. Each element is a single chain from an MCMC algorithm. Each element should be a numeric vector (for univariate draws), or a list.}

\item{distance}{Distance function defined on the space of MCMC draws. Should operate pairwise on the elements of the given chains. See details.}

\item{minDist}{Numeric. Value which specifies the minimum possible distance for two draws
which are not equal. See tsTransform details.}

\item{fuzzy}{Logical. If TRUE computes an approximate version of the TS algorithm.
See tsTransform details.}

\item{fuzzyDist}{Numeric. Parameter for approximate version of ts algorithm. See tsTransform details.}

\item{verbose}{Logical. If TRUE, function prints out information about approximate
computation time}

\item{...}{Catches extra arguments. Not used.}
}
\value{
List of data.frames with columns 'val' which is the TS transformation of each
MCMC draw, and 't' which gives the within-chain ordering of the MCMC draws.
Each data.frame is a separate chain.
}
\description{
Transforms a list of MCMC chains into a list of data.frames using the TS transformation
}
\details{
The TS transformation sets up a traveling salesman algorithm by calculating the
pair-wise distances between each unique draw from the mhDraws and solving the resulting
TS problem with the nearest neighbor (NN) algorithm.

minDist can be used to speed up the algorithm if it is known that
when x != y then distance(x, y) >= minDist. Otherwise this should be ignored.

The fuzzy approximation of the algorithm works by splitting the unique draws into
smaller sets each containing at most 1\% of all unique draws,
and fitting the NN algorithm within each set, and then on the resulting 'end points'
of each set. The sets are created by randomly selecting a representative draw and then
putting the 'closest' draws with distance less than fuzzyDist into that set,
until the set contains 1\% of all unique draws. The fuzzy approximation can GREATLY
reduce computation time, unless the fuzzyDistance specified is too small.
}
