/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.threading.status;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.PredicateUtils;
import org.drugis.common.threading.IterativeTask;
import org.drugis.common.threading.Task;
import org.drugis.common.threading.TaskListener;
import org.drugis.common.threading.activity.ActivityTask;
import org.drugis.common.threading.event.PhaseEvent;
import org.drugis.common.threading.event.TaskEvent;
import org.drugis.common.threading.event.TaskProgressEvent;
import org.drugis.common.threading.status.AbstractProgressModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityTaskProgressModel
extends AbstractProgressModel {
    private Set<Task> d_runningTasks = new HashSet<Task>();
    private Set<Task> d_iterables = new HashSet<Task>();
    private HashMap<Task, Double> d_progress = new HashMap();
    private PhaseListener d_listener = new PhaseListener();
    private Object d_lock = new Object();

    public ActivityTaskProgressModel(ActivityTask activity) {
        this.d_task = activity;
        Set<Task> states = activity.getModel().getStates();
        if (!this.d_task.isFinished()) {
            for (Task state : states) {
                this.d_progress.put(state, 0.0);
                state.addTaskListener(this.d_listener);
            }
        }
        this.d_task.addTaskListener(new TaskListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void taskEvent(TaskEvent e) {
                Object object = ActivityTaskProgressModel.this.d_lock;
                synchronized (object) {
                    if (e instanceof PhaseEvent) {
                        Task phase = ((PhaseEvent)e).getPhase();
                        if (e.getType().equals((Object)TaskEvent.EventType.PHASE_STARTED)) {
                            ActivityTaskProgressModel.this.d_runningTasks.add(phase);
                        } else if (e.getType().equals((Object)TaskEvent.EventType.PHASE_FINISHED)) {
                            ActivityTaskProgressModel.this.d_runningTasks.remove(phase);
                        }
                        ActivityTaskProgressModel.this.setDeterminate(ActivityTaskProgressModel.this.calcDeterminate());
                        ActivityTaskProgressModel.this.setProgress(ActivityTaskProgressModel.this.calcProgress());
                    }
                }
            }
        });
        this.d_iterables.addAll(this.findIterables(states));
    }

    private Collection<? extends IterativeTask> findIterables(Collection<? extends Task> collection) {
        return CollectionUtils.select(collection, PredicateUtils.instanceofPredicate(IterativeTask.class));
    }

    @Override
    protected Double calcProgress() {
        double progress = 0.0;
        for (Task task : this.d_iterables) {
            Double value = this.d_progress.get(task);
            progress += value == null ? 0.0 : value;
        }
        return progress / (double)this.d_iterables.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<String> getPhaseStrings() {
        ArrayList<String> phaseStrings = new ArrayList<String>();
        Object object = this.d_lock;
        synchronized (object) {
            for (Task p : this.d_runningTasks) {
                phaseStrings.add(p.toString() + (p instanceof IterativeTask ? ": " + this.formatProgress(this.d_progress.get(p)) : ""));
            }
        }
        return phaseStrings;
    }

    @Override
    protected boolean calcDeterminate() {
        return !CollectionUtils.intersection(this.d_runningTasks, this.d_iterables).isEmpty() || this.d_task.isFinished();
    }

    private final class PhaseListener
    implements TaskListener {
        private PhaseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taskEvent(TaskEvent event) {
            Object object = ActivityTaskProgressModel.this.d_lock;
            synchronized (object) {
                Task source = event.getSource();
                if (ActivityTaskProgressModel.this.d_progress.containsKey(source)) {
                    this.updateTaskProgress(source, event);
                }
            }
        }

        private void updateTaskProgress(Task source, TaskEvent event) {
            TaskEvent.EventType type = event.getType();
            switch (type) {
                case TASK_FINISHED: {
                    ActivityTaskProgressModel.this.d_progress.put(source, 1.0);
                    break;
                }
                case TASK_PROGRESS: {
                    ActivityTaskProgressModel.this.d_progress.put(source, ActivityTaskProgressModel.this.calcProgress((TaskProgressEvent)event));
                    break;
                }
                case TASK_RESTARTED: 
                case TASK_STARTED: {
                    ActivityTaskProgressModel.this.d_progress.put(source, 0.0);
                }
            }
            ActivityTaskProgressModel.this.setProgress(ActivityTaskProgressModel.this.calcProgress());
            ActivityTaskProgressModel.this.setDeterminate(ActivityTaskProgressModel.this.calcDeterminate());
        }
    }
}

