/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.threading;

import org.drugis.common.threading.AbortedException;
import org.drugis.common.threading.NonSuspendable;
import org.drugis.common.threading.SimpleTask;
import org.drugis.common.threading.Suspendable;
import org.drugis.common.threading.TaskListener;
import org.drugis.common.threading.event.ListenerManager;

public class SimpleSuspendableTask
implements SimpleTask {
    protected ListenerManager d_mgr;
    protected final Suspendable d_suspendable;
    protected boolean d_started = false;
    protected boolean d_finished = false;
    private Throwable d_failure;
    private String d_str;

    public SimpleSuspendableTask(Suspendable suspendable, String str) {
        this.d_suspendable = suspendable;
        this.d_str = str;
        this.d_mgr = new ListenerManager(this);
    }

    public SimpleSuspendableTask(Runnable runnable, String str) {
        this(SimpleSuspendableTask.wrap(runnable), str);
    }

    public SimpleSuspendableTask(Runnable runnable) {
        this(SimpleSuspendableTask.wrap(runnable), runnable.toString());
    }

    public SimpleSuspendableTask(Suspendable suspendable) {
        this(suspendable, suspendable.toString());
    }

    private static Suspendable wrap(Runnable runnable) {
        if (runnable instanceof Suspendable) {
            return (Suspendable)runnable;
        }
        return new NonSuspendable(runnable);
    }

    @Override
    public void addTaskListener(TaskListener l) {
        this.d_mgr.addTaskListener(l);
    }

    @Override
    public void removeTaskListener(TaskListener l) {
        this.d_mgr.removeTaskListener(l);
    }

    @Override
    public void run() {
        this.d_started = true;
        this.d_mgr.fireTaskStarted();
        try {
            this.d_suspendable.run();
        }
        catch (AbortedException e) {
            this.d_mgr.fireTaskAborted();
            return;
        }
        catch (Throwable e) {
            this.d_failure = e;
            this.d_mgr.fireTaskFailed(e);
            return;
        }
        this.d_finished = true;
        this.d_mgr.fireTaskFinished();
    }

    @Override
    public boolean isStarted() {
        return this.d_started;
    }

    @Override
    public boolean isFinished() {
        return this.d_finished;
    }

    @Override
    public boolean isFailed() {
        return this.d_failure != null;
    }

    @Override
    public Throwable getFailureCause() {
        return this.d_failure;
    }

    @Override
    public boolean isAborted() {
        return this.d_suspendable.isAborted();
    }

    @Override
    public boolean isSuspended() {
        return this.d_suspendable.isSuspended();
    }

    @Override
    public boolean suspend() {
        return this.d_suspendable.suspend();
    }

    @Override
    public boolean wakeUp() {
        return this.d_suspendable.wakeUp();
    }

    @Override
    public boolean abort() {
        return this.d_suspendable.abort();
    }

    public String toString() {
        return this.d_str;
    }
}

