% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geelm-confint.R
\name{confint.geelm}
\alias{confint.geelm}
\alias{confint.geeglm}
\title{Confidence Intervals for geelm objects}
\usage{
\method{confint}{geelm}(object, parm = NULL, level = 0.95, std.err = "san.se", ...)

\method{confint}{geeglm}(object, parm = NULL, level = 0.95, std.err = "san.se", ...)
}
\arguments{
\item{object}{a fitted model object.}

\item{parm}{specification of which parameters are to be given
confidence intervals, either a vector of numbers or a vector
of names.  If missing, all parameters are considered.}

\item{level}{the confidence level required.}

\item{std.err}{Which standard error estimation method that should
be used for computing the confidence intervals. Only \code{san.se}
is supported for geelm objects but \code{jack}, \code{j1s} or \code{fij} may
be used for geeglm objects (if they have been estimated when
fitting the model).}

\item{...}{additional argument(s) for methods.}
}
\value{
A matrix (or vector) with columns giving lower and upper
confidence limits for each parameter.
}
\description{
Compute Wald confidence intervals for mean structure parameters of geelm object.
}
\section{Functions}{
\itemize{
\item \code{confint.geeglm}: 
}}

