% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ll_xycholv-ploglik.R, R/ll_xycholv.R
\name{ploglik_xycholv}
\alias{ploglik_xycholv}
\alias{ll_xycholv}
\title{Compute the log-likelihood of a model}
\usage{
ploglik_xycholv(
  x,
  y,
  cholv,
  mu = NULL,
  reml = FALSE,
  minus2 = TRUE,
  return_ll = TRUE
)

ll_xycholv(
  x,
  y,
  cholv,
  mu = NULL,
  reml = FALSE,
  minus2 = TRUE,
  return_ll = TRUE
)
}
\arguments{
\item{x}{The matrix of covariates.}

\item{y}{The vector of observed responses.}

\item{cholv}{The cholesky decomposition of the covariance
matrix of \code{y} (or of that matrix divided by \code{psill} for
\code{loglik_xycholv}.}

\item{mu}{A single numeric value indicating the assumed
mean of the underlying process.}

\item{reml}{A logical value. Should the Restricted
Maximum Likelihood be returned. The default is
\code{FALSE}.}

\item{minus2}{A logical value. Should -2 times the
log-likelihood be returned. The default is \code{TRUE}.}

\item{return_ll}{A logical value. Should the
log-liklihood be returned? Default is \code{TRUE}. If
\code{FALSE}, the estimated partial sill is returned.}
}
\value{
A likelihood value, -2 times the likelihood
  value, or the estimated partial sill, depending on the
  user's argument choices.
}
\description{
\code{ll_xycholv} computes the log-likelihood of
multivariate normal data using components typically found
in a \code{geolm}. For \code{ploglik_xycholv}, 
\code{cholv} is the cholesky decomposition of the 
covariance matrix for the observed data after dividing
the matrix by the (estimated) \code{psill}. See the
examples below.
Depending on parameter choices, the
function can return the log-likelihood, the restricted
log-likelihood, -2 times the log-likelihood or restricted
log-likelihood, or the estimated partial sill for both a
maximum likelihood and restricted maximum likelihood
setting. This is intended to be an internal function, so
minimal error checking is done.
}
\examples{
y = rnorm(10)
x = matrix(rep(1, length(y)))
coords = matrix(runif(length(y) * 2), ncol = 2)
d = as.matrix(dist(coords))
pv = exp(-d/3) + 0.1 * diag(length(y))
est_psill = ploglik_xycholv(x, y, chol(pv), return_ll = FALSE)
v = pv * est_psill
# same result
ploglik_xycholv(x, y, chol(pv), minus2 = FALSE)
ll_xycholv(x, y, chol(v), minus2 = FALSE)
}
\references{
Statistical Methods for Spatial Data
  Analysis. Oliver Schabenberger and Carol A. Gotway
  (Chapman & Hall/CRC Press) 2005. pp. 259-263
}
