% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bandCopyWholeRaster}
\alias{bandCopyWholeRaster}
\title{Copy a whole raster band efficiently}
\usage{
bandCopyWholeRaster(
  src_filename,
  src_band,
  dst_filename,
  dst_band,
  options = NULL,
  quiet = FALSE
)
}
\arguments{
\item{src_filename}{Filename of the source raster.}

\item{src_band}{Band number in the source raster to be copied.}

\item{dst_filename}{Filename of the destination raster.}

\item{dst_band}{Band number in the destination raster to copy into.}

\item{options}{Optional list of transfer hints in a vector of \code{"NAME=VALUE"}
pairs. The currently supported \code{options} are:
\itemize{
\item \code{"COMPRESSED=YES"} to force alignment on target dataset block sizes to
achieve best compression.
\item \code{"SKIP_HOLES=YES"} to skip chunks that contain only empty blocks.
Empty blocks are blocks that are generally not physically present in the
file, and when read through GDAL, contain only pixels whose value is the
nodata value when it is set, or whose value is 0 when the nodata value is
not set. The query is done in an efficient way without reading the actual
pixel values (if implemented by the raster format driver, otherwise will
not be skipped).
}}

\item{quiet}{Logical scalar. If \code{TRUE}, a progress bar will not be
displayed. Defaults to \code{FALSE}.}
}
\value{
Logical indicating success (invisible \code{TRUE}).
An error is raised if the operation fails.
}
\description{
\code{bandCopyWholeRaster()} copies the complete raster contents of one band to
another similarly configured band. The source and destination bands must
have the same xsize and ysize. The bands do not have to have the same data
type. It implements efficient copying, in particular "chunking" the copy in
substantial blocks. This is a wrapper for \code{GDALRasterBandCopyWholeRaster()}
in the GDAL API.
}
\examples{
## copy Landsat data from a single-band file to a new multi-band image
b5_file <- system.file("extdata/sr_b5_20200829.tif", package="gdalraster")
dst_file <- paste0(tempdir(), "/", "sr_multi.tif")
rasterFromRaster(b5_file, dst_file, nbands=7, init=0)
opt <- c("COMPRESSED=YES", "SKIP_HOLES=YES")
bandCopyWholeRaster(b5_file, 1, dst_file, 5, options=opt)
ds <- new(GDALRaster, dst_file)
ds$getStatistics(band=5, approx_ok=FALSE, force=TRUE)
ds$close()

deleteDataset(dst_file)
}
\seealso{
\code{\link[=GDALRaster]{GDALRaster-class}}, \code{\link[=create]{create()}}, \code{\link[=createCopy]{createCopy()}},
\code{\link[=rasterFromRaster]{rasterFromRaster()}}
}
