% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streaming.R
\name{apply_time.array}
\alias{apply_time.array}
\title{Apply a function over pixel time series in a four-dimensional (band, time, y, x) array}
\usage{
\method{apply_time}{array}(x, FUN, ...)
}
\arguments{
\item{x}{four-dimensional input array with dimensions band, time, y, x (in this order)}

\item{FUN}{function that receives a vector of band values in a one-dimensional array}

\item{...}{further arguments passed to FUN}
}
\description{
Apply a function over pixel time series in a four-dimensional (band, time, y, x) array
}
\details{
FUN is expected to produce a matrix (or vector if result has only one band) where rows are interpreted as new bands and columns represent time.
}
\note{
This is a helper function that uses the same dimension ordering as gdalcubes. It can be used to simplify 
the application of R functions e.g. over time series in a data cube.
}
\examples{
d <- c(4,16,32,32)
x <- array(rnorm(prod(d)), d)
z <- apply_time(x, function(v) {
  y = matrix(NA, ncol=ncol(v), nrow=2)
  y[1,] = (v[1,] + v[2,]) / 2
  y[2,] = (v[3,] + v[4,]) / 2
  y
})
dim(z)
}
