% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcite_cite_over_time.R
\name{gcite_cite_over_time}
\alias{gcite_cite_over_time}
\alias{gcite_cite_over_time.xml_node}
\alias{gcite_cite_over_time.xml_document}
\alias{gcite_cite_over_time.character}
\alias{gcite_cite_over_time.default}
\title{Parse Google Citations Over Time}
\usage{
gcite_cite_over_time(doc, ...)

\method{gcite_cite_over_time}{xml_node}(doc, ...)

\method{gcite_cite_over_time}{xml_document}(doc, ...)

\method{gcite_cite_over_time}{character}(doc, ...)

\method{gcite_cite_over_time}{default}(doc, ...)
}
\arguments{
\item{doc}{A xml_document or the url for the main page}

\item{...}{arguments passed to \code{\link{GET}}}
}
\value{
A matrix of citations
}
\description{
Parses a google citations over time from the main
Citation page
}
\examples{
if (!is_travis()) {
library(httr)
library(rvest) 
url = "https://scholar.google.com/citations?user=T9eqZgMAAAAJ"
url = gcite_url(url = url, pagesize = 10, cstart = 0) 
ind = gcite_cite_over_time(url)
doc = content(httr::GET(url))
ind = gcite_cite_over_time(doc)
ind_nodes = rvest::html_nodes(doc, ".gsc_md_hist_b")
ind = gcite_cite_over_time(ind_nodes)
}
}
