% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbm.loop.R
\name{gbm.loop}
\alias{gbm.loop}
\title{Calculate Coefficient Of Variation surfaces for gbm.auto predictions}
\usage{
gbm.loop(
  loops = 10,
  savedir = tempdir(),
  savecsv = TRUE,
  calcpreds = TRUE,
  varmap = TRUE,
  measure = "CPUE",
  cleanup = FALSE,
  grids = NULL,
  samples,
  expvar,
  resvar,
  randomvar = FALSE,
  tc = c(2),
  lr = c(0.01),
  bf = 0.5,
  n.trees = 50,
  ZI = "CHECK",
  fam1 = c("bernoulli", "binomial", "poisson", "laplace", "gaussian"),
  fam2 = c("gaussian", "bernoulli", "binomial", "poisson", "laplace"),
  simp = TRUE,
  gridslat = 2,
  gridslon = 1,
  multiplot = FALSE,
  cols = grey.colors(1, 1, 1),
  linesfiles = TRUE,
  smooth = FALSE,
  savegbm = FALSE,
  loadgbm = NULL,
  varint = FALSE,
  map = TRUE,
  shape = NULL,
  RSB = FALSE,
  BnW = FALSE,
  alerts = FALSE,
  pngtype = c("cairo-png", "quartz", "Xlib"),
  gaus = TRUE,
  MLEvaluate = TRUE,
  runautos = TRUE,
  Min.Inf = NULL,
  ...
)
}
\arguments{
\item{loops}{The number of loops required, integer.}

\item{savedir}{Save outputs to a temporary directory (default) else change to
current directory e.g. "/home/me/folder". Do not use getwd() here.}

\item{savecsv}{Save coefficients of variation in simple & extended format.}

\item{calcpreds}{Calculate coefficients of variation of predicted abundance?}

\item{varmap}{Create a map of the coefficients of variation outputs?}

\item{measure}{Map legend, coefficients of variation of what? Default CPUE.}

\item{cleanup}{Remove gbm.auto-generated directory each loop? Default FALSE.}

\item{grids}{See gbm.auto help for all subsequent params.}

\item{samples}{See gbm.auto help.}

\item{expvar}{See gbm.auto help.}

\item{resvar}{See gbm.auto help.}

\item{randomvar}{See gbm.auto help.}

\item{tc}{See gbm.auto help.}

\item{lr}{See gbm.auto help.}

\item{bf}{See gbm.auto help.}

\item{n.trees}{See gbm.auto help.}

\item{ZI}{See gbm.auto help. Choose one.}

\item{fam1}{See gbm.auto help. Choose one.}

\item{fam2}{See gbm.auto help. Choose one.}

\item{simp}{See gbm.auto help.}

\item{gridslat}{See gbm.auto help.}

\item{gridslon}{See gbm.auto help.}

\item{multiplot}{See gbm.auto help. Default False}

\item{cols}{See gbm.auto help.}

\item{linesfiles}{See gbm.auto help; TRUE or linesfiles calculations fail.}

\item{smooth}{See gbm.auto help.}

\item{savegbm}{See gbm.auto help.}

\item{loadgbm}{See gbm.auto help.}

\item{varint}{See gbm.auto help.}

\item{map}{See gbm.auto help.}

\item{shape}{See gbm.auto help.}

\item{RSB}{See gbm.auto help.}

\item{BnW}{See gbm.auto help.}

\item{alerts}{See gbm.auto help; default FALSE as frequent use can crash
RStudio.}

\item{pngtype}{See gbm.auto help. Choose one.}

\item{gaus}{See gbm.auto help.}

\item{MLEvaluate}{See gbm.auto help.}

\item{runautos}{Run gbm.autos, default TRUE, turn off to only collate
numbered-folder results.}

\item{Min.Inf}{Dummy param for package testing for CRAN, ignore.}

\item{...}{Additional params for gbm.auto sub-functions including gbm.step.}
}
\value{
Returns a data frame of lat, long, 1 predicted abundance per loop,
and a final variance score per cell.
}
\description{
Bagging introduces stochasticity which can result in sizeable variance in
output predictions by gbm.auto for small datasets. This function runs a user-
specified number of loops through the same gbm.auto parameter combinations
and calculates the Coefficient Of Variation in the predicted abundance scores
 for each site aka cell. This can be mapped, to spatially demonstrate the
 output variance range.
}
\examples{
\donttest{
# Not run: downloads and saves external data.
library("gbm.auto")
data(grids) # load grids
data(samples) # load samples
gbmloopexample <- gbm.loop(loops = 2, samples = samples,
grids = grids, expvar = c(4:10), resvar = 11, simp = F)
}

}
\author{
Simon Dedman, \email{simondedman@gmail.com}
}
