% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breaks.grid.R
\name{breaks.grid}
\alias{breaks.grid}
\title{Defines breakpoints for draw.grid and legend.grid; mapplots fork}
\usage{
breaks.grid(grd, quantile = 0.975, ncol = 12, zero = TRUE)
}
\arguments{
\item{grd}{An array produced by make.grid or a list produced by
make.multigrid or a vector of positive values.}

\item{quantile}{The maximum value of the breaks will be determined by the
quantile given here. This can be used to deal with outlying values in grd.
If quantile = 1 then the maximum value of the breaks will be the same as the
maximum value in grd.}

\item{ncol}{Number of colours to be used, always one more than the number of
breakpoints. Defaults to 12.}

\item{zero}{Logical, should zero be included as a separate category? Defaults
to TRUE.}
}
\value{
A vector of breakpoints for draw.grid in mapplots
}
\description{
Defines breakpoints from values in grd with options to exclude outliers,
set number of bins, and include a dedicated zero column.
Forked by SD 05/01/2019 to add 'lo', else bins always begin at 0, killing
plotting when all data are in a tight range at high values e.g. 600:610
}
\examples{
breaks.grid(100,ncol=6)
breaks.grid(100,ncol=5,zero=FALSE)

# create breaks on the log scale
exp(breaks.grid(log(10000),ncol=4,zero=FALSE))
}
\author{
Simon Dedman, \email{simondedman@gmail.com}

Hans Gerritsen
}
