% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbif_version.R
\name{gbif_version}
\alias{gbif_version}
\title{Get the latest gbif version string}
\usage{
gbif_version(
  local = FALSE,
  dir = gbif_dir(),
  bucket = gbif_default_bucket(),
  all = FALSE,
  ...
)
}
\arguments{
\item{local}{Search only local versions? logical, default \code{FALSE}.}

\item{dir}{local directory (\code{\link[=gbif_dir]{gbif_dir()}})}

\item{bucket}{Which remote bucket (region) should be checked}

\item{all}{show all versions? (logical, default \code{FALSE})}

\item{...}{additional arguments to \link[arrow:s3_bucket]{arrow::s3_bucket}}
}
\value{
latest available gbif version, string
}
\description{
Can also return latest locally downloaded version, or list all versions
}
\details{
A default version can be set using option \code{gbif_default_version}
}
\examples{
## Latest local version available:
gbif_version(local=TRUE)
## default version
options(gbif_default_version="2021-01-01")
gbif_version()
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Latest online version available:
gbif_version()
## All online versions:
gbif_version(all=TRUE)
\dontshow{\}) # examplesIf}
}
