% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_static_feeds.R
\name{get_system_alerts}
\alias{get_system_alerts}
\title{Save the system_alerts feed.}
\usage{
get_system_alerts(city, directory, file = "system_alerts.rds")
}
\arguments{
\item{city}{A character string or a url to an active gbfs.json feed.}

\item{directory}{The name of an existing folder or folder to be created, where the feed will
will be saved.}

\item{file}{The name of the file to be saved. Must end in .rds.}
}
\value{
A .rds object generated from the current system_alerts feed.
}
\description{
\code{get_system_alerts} saves the system_alerts feed for a given city as a .rds object. Go to 
`https://github.com/NABSA/gbfs/blob/master/gbfs.md` to see metadata for this dataset.
}
\examples{
\donttest{get_system_alerts(city = 
"http://biketownpdx.socialbicycles.com/opendata/system_alerts.json", directory = tempdir())}
\donttest{get_system_alerts(city = "Santa Monica", directory = tempdir())}
}
