% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fnfp.R
\name{fnfp}
\alias{fnfp}
\title{Estimates the number of false positives for given dimensions (n,k) and given order statistics nu}
\usage{
fnfp(n,k,p0,nu,nufp,gr=F,nsim=0,kmx=0,idum=1)
}
\arguments{
\item{n}{The dimension of dependent variable}

\item{k}{The number of covariates}

\item{p0}{Cut-off P-value}

\item{nu}{The order statistic}

\item{gr}{ Logical, if TRUE then p0<-p0/k as is the default for graphs}

\item{nufp}{Requires a data set nufp.rda of previous simulations}

\item{nsim}{Number of simulations}

\item{kmx}{Maximum number of selected covariates, must be larger than nu, for example nu+10}

\item{idum}{ Seed for the random number generator}
}
\value{
enfp Estimated number of false positives.

mnfp Mean number of false positives when simulating.

hist Histogram of number of false positives when simulating
}
\description{
Interpolates using nufp or simulates the number of false positives for given dimensions (n,k) and given order statistics nu
}
\examples{
a<-fnfp(100,24,0.01,1:5,nufp,nsim=1000,kmx=10)
}
