% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{var2label}
\alias{var2label}
\title{Render gasanalyzer variables or values using mathematical notation.}
\usage{
var2label(varname, use_units = FALSE, val = NULL, ...)
}
\arguments{
\item{varname}{a character list or vector argument with variable names.}

\item{use_units}{whether or not to append default units to the resulting.
expression. It is better to rely on the units in the actual data, which is
handled automatically by newer ggplot2 versions.}

\item{val}{a value to display rather than the variable name. Needs to be of
the same length as varname and if not a character vector it should be
coercible to one. NAs are replaced with the plotmath
expressions.}

\item{...}{options passed on to make_unit_label.}
}
\value{
a list of plotmath expressions.
}
\description{
The argument is converted to a plotmath expression that can be used using
\code{plot} or \code{ggplot2}. If there is no known plotmath expression defined,
the argument is returned as is.
}
\examples{
# make labels
lbls <- var2label(c("GasEx.Ci", "GasEx.A"), use_units = TRUE)
print(lbls)

# plot
plot(1, type = "n", xlab = lbls[[1]], ylab = lbls[[2]])
# add temperature as title, removing [] from the units:
title(main = var2label("Meas.Tleaf",use_units = TRUE, val = 25,
  group = c("", ""))[[1]])

}
\seealso{
plotmath
}
