% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{amap}
\alias{amap}
\alias{Ops.garray}
\title{Mapping matching dimension of arrays with a function}
\usage{
amap(FUN, ..., MoreArgs = NULL, SIMPLIFY = TRUE, VECTORIZED = NA)

\method{Ops}{garray}(e1, e2)
}
\arguments{
\item{FUN}{Known vectorized function is recognized if passed in
as character.  Other functions will be vectorized by \code{.mapply()}.}

\item{...}{Arrays with margins (names of dimnames) and maybe with sdim.
Orders of their margins can be different, but the extent along a
margin is matched. Unmatched margins are broadcasting like outer().
Scalar (length 1 vector) do not contribute margins and
not broadcast here (they will broadcast by \code{.mapply()} later).}

\item{MoreArgs}{a list of other arguments to 'FUN', no matching of margins.}

\item{SIMPLIFY}{logical, attempt to reduce the result to exclude recursive
structure (no list hierachy but plain generalized array).}

\item{VECTORIZED}{Whether FUN is vectorized will affect the behaviours.
Some combination of FUN and VECTORIZED is not simply slowing down,
but produces meaningless results or even stop (e.g., cumsum).
TRUE - call \code{FUN} once with arrays being reorganize on dimensions;
FALSE - call \code{FUN} many times (via \code{.mapply}), with each cell of arrays.}

\item{e1, e2}{Generalized arrays, being operands.}
}
\value{
The dimensions is deduced from inputs.
}
\description{
Generalized and smart mapply()/Map()/outer()/sweep() for data mapping.
Matching is checked automatically.
}
\examples{
a <- garray(1:24, c(4,6,2), dimnames=list(X=1:4, Y=letters[1:6], Z=NULL),
	sdim=list(XX=c(x1=3,x2=1), YY=c(y1=1,y2=2)))
b <- garray(1:6/10,6,dimnames=list(Y=letters[1:6]))
c <- garray(1:4/100,c(X=4))
d <- garray(1:4/1000,c(Y=4))
e <- garray(1:2/1000,c(X=2))
f <- garray(0,c(Z=2))
g <- garray(0,c(ZZ=2))
m1 <- amap(psummary,c,a,b,      0.0001, VECTORIZED=FALSE)
m2 <- amap(sum,     c,a,b,      0.0001, VECTORIZED=FALSE)
m3 <-               c+a+b+      0.0001
n1 <- amap(sum,     c,a,b,d,    0.0001, VECTORIZED=FALSE)
n2 <- amap(sum,     c,a,b,e,    0.0001, VECTORIZED=FALSE)
n3 <- amap(sum,     c,a,b,e,f,  0.0001, VECTORIZED=FALSE)
p1 <- amap(sum,     c,a,b,e,f,g,0.0001, VECTORIZED=FALSE)
m1==m2
m2==m3
m2==aperm(m3, 3:1)
}
