% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miamiplot2.R
\name{miamiplot2}
\alias{miamiplot2}
\title{Miami Plot}
\usage{
miamiplot2(
  gwas1,
  gwas2,
  name1 = "GWAS 1",
  name2 = "GWAS 2",
  chr1 = "chr",
  chr2 = "chr",
  pos1 = "pos",
  pos2 = "pos",
  p1 = "p",
  p2 = "p",
  z1 = NULL,
  z2 = NULL,
  sug = 1e-05,
  sig = 5e-08,
  pcutoff = 0.1,
  topcols = c("green3", "darkgreen"),
  botcols = c("royalblue1", "navy"),
  yAxisInterval = 5
)
}
\arguments{
\item{gwas1}{The first of two GWAS datasets to plot, in the upper region.}

\item{gwas2}{The second of two GWAS datasets to plot, in the lower region.}

\item{name1}{The name of the first dataset, plotted above the upper plot region. Defaults to \samp{"GWAS 1"}.}

\item{name2}{The name of the second dataset, plotted below the lower plot region. Defaults to \samp{"GWAS 2"}.}

\item{chr1}{The name of the column containing chromosome number in \env{gwas1}. Defaults to \samp{"chr"}.}

\item{chr2}{The name of the column containing chromosome number in \env{gwas2}. Defaults to \samp{"chr"}.}

\item{pos1}{The name of the column containing SNP position in \env{gwas1}. Defaults to \samp{"pos"}.}

\item{pos2}{The name of the column containing SNP position in \env{gwas2}. Defaults to \samp{"pos"}.}

\item{p1}{The name of the column containing p-values in \env{gwas1}. Defaults to \samp{"p"}.}

\item{p2}{The name of the column containing p-values in \env{gwas2}. Defaults to \samp{"p"}.}

\item{z1}{The name of the column containing z-values in \env{gwas1}. Defaults to \samp{"NULL"}.}

\item{z2}{The name of the column containing z-values in \env{gwas2}. Defaults to \samp{"NULL"}.}

\item{sug}{The threshold for suggestive significance, plotted as a light grey dashed line.}

\item{sig}{The threshold for genome-wide significance, plotted as a dark grey dashed line.}

\item{pcutoff}{The p-value threshold below which SNPs will be ignored. Defaults to 0.1. It is not recommended to set this higher as it will narrow the central gap between the two plot region where the chromosome number is plotted.}

\item{topcols}{A vector of two colours to plot alternating chromosomes in for the upper plot. Defaults to green3 and darkgreen.}

\item{botcols}{A vector of two colours to plot alternating chromosomes in for the lower plot. Defaults to royalblue1 and navy.}

\item{yAxisInterval}{The interval between tick marks on the y-axis. Defaults to 5, 2 may be more suitable for plots with larger minimum p-values.}
}
\value{
In addition to creading a Miami plot, the function returns a data frame containing x coordinates for chromosome start positions (required for \code{\link[gap]{labelManhattan}})
}
\description{
Creates a Miami plot to compare results from two genome-wide association analyses.
}
\note{
Extended to handle extreme P values.
}
\examples{
\dontrun{
# miamiplot2(gwas1, gwas2)
# chrmaxpos <- miamiplot2(gwas1, gwas2)
gwas <- within(mhtdata[c("chr","pos","p")], {z=qnorm(p/2)})
chrmaxpos <- miamiplot2(gwas,gwas,name1="Batch 2",name2="Batch 1",z1="z",z2="z")
labelManhattan(chr=c(2,16),pos=c(226814165,52373776),name=c("AnonymousGene","FTO"),
               gwas,gwasZLab="z",chrmaxpos=chrmaxpos)
}
}
\author{
Jonathan Marten
}
\keyword{GWAS}
\keyword{Manhattan}
\keyword{Miami}
