C FILE "FIELD.INC" =====================================================
C COMMON /FIELD/: CONTAINS DATA STRUCTURES FOR ACCESSING INPUT DATA
C
C OVERVIEW:
C     EACH INPUT RECORD CONTAINS A COLLECTION OF FIELDS WHICH OCCUPY A
C CONSISTENT COLUMN RANGE.  THE STRUCTURE OF A GIVEN RECORD IS GIVEN
C IN TERMS OF FORTRAN FORMAT SPECIFIERS.  (NOTE THAT LOGICAL INPUT
C RECORDS MAY SPAN MORE THAN ONE PHYSICAL RECORD, AS DEFINED IN THE
C INPUT FORMAT.)  EACH FIELD IS IDENTIFIED BY A UNIQUE VARIABLE NAME
C WHICH CAN OPTIONALLY BE USED IN DATA TRASFORMATIONS.
C     TWO DIFFERENT FORMAT REPRESENTATIONS ARE MAINTAINED:  1) A SINGLE
C ALPHA FORMAT USED FOR READING AN ENTIRE DATA RECORD INTO CHARACTER
C STRING BUFFERS (ONE FOR EACH FIELD); AND 2) NUMERIC FORMATS USED FOR
C EXTRACTING NUMERIC VALUES FROM EACH OF THE CHARACTER STRING BUFFERS.
C A TWO-STAGE PROCESS IS USED TO ENABLE CHECKING OF THE INPUT FIELDS
C FOR BLANKS.  IF A BLANK FIELD IS READ, A MISSING VALUE CODE IS
C SUBSTITUTIED FOR THE NUMERIC VALUE.
C
C VARIABLES:
C     MAXFLD   -- DIMENSION OF ARRAYS; DEFINES LIMIT ON NUMBER OF FIELDS
C     MAXFSZ   -- DEFINES LIMIT ON THE NUMBER OF CHARACTERS IN A FIELD
C     NFLDIN   -- NUMBER OF FIELDS READ FROM INPUT FILE
C     FLDTYP() -- IDENTIFIES THE STATUS OF EACH FIELD AS FOLLOWS:
C                 0 = UNDEFINED FIELD (NOT SPECIFIED ON INPUT)
C                 1 = CHARACTER (HOLLERITH, STORED INTERNALLY AS F.P.)
C                 2 = FLOATING POINT NUMERIC
C                 3 = INTEGER NUMERIC (STORED INTERNALLY AS F.P.)
C     FLDNAM() -- VARIABLE NAMES FOR EACH FIELD
C     FLDNCH() -- LENGTH OF VARIABLE NAMES
C     FLDBLK() -- MISSING VALUE CODE FOR EACH FIELD
C     FLDBUF() -- ALPHA BUFFERS FOR EACH FIELD OF CURRENT RECORD
C     FLDOBS() -- NUMERIC VALUE OF EACH FIELD IN CURRENT RECORD
C     FMTALP   -- ALPHABETIC FORMAT FOR READING INPUT DATA
C     FMTX()   -- INDIVIDUAL NUMERIC FORMATS FOR EACH FIELD
C
      PARAMETER (MAXFLD=20, MAXFSZ=20)

      INTEGER           NFLDIN
      INTEGER           FLDTYP(MAXFLD)
      CHARACTER         FLDNAM(MAXFLD)*12
      INTEGER           FLDNCH(MAXFLD)
      CHARACTER         FLDBUF(MAXFLD)*(MAXFSZ)
      DOUBLE PRECISION  FLDOBS(MAXFLD)
      DOUBLE PRECISION  FLDBLK(MAXFLD)
      CHARACTER         FMTALP*160
      CHARACTER         FMTX(MAXFLD)*12

      COMMON /FIELD/    FLDTYP, FLDNCH, FLDBLK, FLDOBS, NFLDIN
      COMMON /FIELDC/   FLDNAM, FLDBUF, FMTALP, FMTX

C END OF FILE "FIELD.INC" ==============================================
