% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdGenerate.R
\name{gdGenerateParameters}
\alias{gdGenerateParameters}
\title{Specify parameters for generation of generative data}
\usage{
gdGenerateParameters(numberOfSamples = 1e+05, dropout = 0.05)
}
\arguments{
\item{numberOfSamples}{Number of generated samples}

\item{dropout}{Value in the range of 0 to 1. Specifies the rate of hidden
units that are dropped. Dropout is a regularization method to prevent
overfitting. See function gdTrainParameters().}
}
\value{
List of parameters for generation of generative data
}
\description{
Specify parameters for generation of generative data. These parameters are
passed to function gdGenerate().
}
\examples{
\dontrun{
generateParameters <- gdGenerateParameters(numberOfSamples = 100000)}
}
