% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.gamtest.R
\name{plot.gamtest}
\alias{plot.gamtest}
\title{Plot a gamtest Object}
\usage{
\method{plot}{gamtest}(x, test.statistic = FALSE,
  test.stat.type = "density", main = "", n = 256,
  legend.position = "topright", se.est = FALSE, data.pts = FALSE,
  type = "contour", ...)
}
\arguments{
\item{x}{A gamtest object.}

\item{test.statistic}{If TRUE, plot the density of the test statistic under null hypothesis; if FALSE, plot the estimated curves/surfaces.}

\item{test.stat.type}{must have "test.statistic=TRUE". Default is "test.stat.type=density". If "test.stat.type=hist", plot the histogram of the test statistic under null.}

\item{main}{The title of the plot.}

\item{n}{The number of points that are used to draw the curves or surfaces in the plot.}

\item{legend.position}{the position of legend in the plot: "topright", "topleft", "bottomright", "bottomleft", etc.}

\item{se.est}{If TRUE, plot the pointwise 95\% confidence intervals of curves; if FALSE, don't plot the pointwise confidence intervals.}

\item{data.pts}{If TRUE, plot raw data points. If FALSE, only plot estimated curves/surfaces.}

\item{type}{Only used for ploting surfaces. If "type=contour",then contour plot from vis.gam function in mgcv package; if "type=persp", then plot persp from vis.gam function;
if "type=plotly.persp", then plot persp from plotly package.}

\item{...}{Other options from package ``mgcv'' ``vis.gam()'' function.}
}
\description{
This function plots the semiparametric estimation of nonlinear curves and surface.
}
\details{
This function is to plot a gamtest object. If "test.statistic=TRUE", a density plot of the test statistic under null hypothesis will be generated;
if "test.statistic=FALSE", the estimated curves/surfaces for all groups are drawn.
}
\examples{
\dontshow{
n1 <- 30
x1 <- runif(n1,min=0, max=3)
sd1 <- 0.2
e1 <- rnorm(n1,sd=sd1)
y1 <- sin(2*x1) + cos(2*x1) + e1

n2 <- 30
x2 <- runif(n2, min=0, max=3)
sd2 <- 0.25
e2 <- rnorm(n2, sd=sd2)
y2 <- sin(2*x2) + cos(2*x2) + x2 + e2

data.bind <- rbind(cbind(x1,y1,1), cbind(x2,y2,2))
data.bind <- data.frame(data.bind)
colnames(data.bind)=c('x','y','group')

t1 <- gam.grptest(y~s(x,bs="cr"), test=~group, data=data.bind, parallel=FALSE)
t1
plot(t1)}
\donttest{
n1 <- 200
x1 <- runif(n1,min=0, max=3)
sd1 <- 0.2
e1 <- rnorm(n1,sd=sd1)
y1 <- sin(2*x1) + cos(2*x1) + e1

n2 <- 120
x2 <- runif(n2, min=0, max=3)
sd2 <- 0.25
e2 <- rnorm(n2, sd=sd2)
y2 <- sin(2*x2) + cos(2*x2) + x2 + e2

data.bind <- rbind(cbind(x1,y1,1), cbind(x2,y2,2))
data.bind <- data.frame(data.bind)
colnames(data.bind)=c('x','y','group')

t1 <- gam.grptest(y~s(x,bs="cr"),test=~group,data=data.bind)
t1
plot(t1)
plot(t1,test.statistic=TRUE)

########
## Semiparametric test the equality for regression surfaces
## Simulate data sets

n1 <- 200
x11 <- runif(n1,min=0, max=3)
x12 <- runif(n1,min=0, max=3)
sd1 <- 0.2
e1 <- rnorm(n1,sd=sd1)
y1 <- 2*x11^2 + 3*x12^2  + e1

n2 <- 120
x21 <- runif(n2, min=0, max=3)
x22 <- runif(n2, min=0, max=3)
sd2 <- 0.25
e2 <- rnorm(n2, sd=sd2)
y2 <- 2*x21^2 + 3*x22^2 + 4*sin(2*pi*x21) + e2

n3 <- 150
x31 <- runif(n3,min=0, max=3)
x32 <- runif(n3,min=0, max=3)
sd3 <- 0.2
e3 <- rnorm(n3,sd=sd1)
y3 <- 2*x31^2 + 3*x32^2  + e3

data.bind <- rbind(cbind(x11, x12 ,y1,1), cbind(x21, x22, y2,2), cbind(x31, x32, y3,3))
data.bind <- data.frame(data.bind)
colnames(data.bind)=c('x1','x2', 'y','group')

tspl <- gam.grptest(y~te(x1,x2),test=~group,data=data.bind,N.boot=200,m=225,parallel=FALSE)
tspl$p.value #p-value
plot(tspl)
plot(tspl,test.statistic = TRUE)
plot(tspl,type="plotly.persp")
plot(tspl,type="plotly.persp", data.pts=TRUE)}

}
\seealso{
\code{\link[mgcv]{gam}} \code{\link[gamm4]{gamm4}} \code{\link{gamm4.grptest}} \code{\link{gam.grptest}}
}
