\name{fitFixBP}

\alias{fitFixBP}
\alias{fitFreeKnots}
\title{Functions to Fit Univariate Break Point Models  }
\description{
There are two functions here. The functions \code{fitFixBP} allows the fit a univariate regression using 
piecewise polynomials with known break points while the function \code{fitFreeKnots} estimates the break points.  
}
\usage{
fitFixBP(x, y, w = NULL, knots = NULL, degree = 3, fixed = NULL, ...)
fitFreeKnots(x, y, w = NULL, knots = NULL, degree = 3, fixed = NULL, 
             trace = 0, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
the x variable}
  \item{y}{the  response variable}
  \item{w}{the prior weights}
  \item{knots}{the position of the interior knots for  \code{fitFixBP} or starting values for  \code{fitFreeKnots}}
  \item{degree}{the degree if the piecewise  polynomials}
  \item{fixed}{this is to be able to fit fixed break points}
  \item{trace}{controlling the trace of of \code{optim()} }
  \item{\dots}{for extra arguments}
  }
\details{
The functions \code{fitFreeKnots()} is loosely based on the  \code{curfit.free.knot()} function of package 
\pkg{DierckxSpline} of  Sundar Dorai-Raj and Spencer Graves. 
}
\value{
The functions \code{fitFixBP} and \code{fitFreeKnots} return an object \code{FixBreakPointsReg} and 
\code{FreeBreakPointsReg} respectively with the following items:
 \item{fitted.values}{the fitted values of the model}
 \item{residuals}{the residuals of the model}
 \item{df}{the degrees of freedom fitted in the model}
 \item{rss}{the residuals sum of squares}
 \item{knots}{the knots used in creating the beta-function base}
 \item{fixed}{the fixed break points if any}
 \item{breakPoints}{the interior (estimated) break points (or knots)}
 \item{coef}{the coefficients of the linear  part of the model}
 \item{degree}{the degree of the piecewise polynomial}
 \item{y}{the y variable}
 \item{x}{the x variable}
 \item{w}{the prior weights}
}
\references{

Dierckx, P. (1991) \emph{Curve and Surface Fitting with Splines}, Oxford Science Publications

Stasinopoulos D. M. Rigby R.A. (2007) Generalized additive models for location scale and shape (GAMLSS) in R.
\emph{Journal of Statistical Software}, Vol. \bold{23}, Issue 7, Dec 2007, \url{http://www.jstatsoft.org/v23/i07}.

Rigby, R. A. and  Stasinopoulos D. M. (2005). Generalized additive models for location, scale and shape,(with discussion), 
\emph{Appl. Statist.}, \bold{54}, part 3, pp 507-554.

Stasinopoulos D. M., Rigby R.A. and Akantziliotou C. (2006) Instructions on how to use the GAMLSS package in R.
Accompanying documentation in the current GAMLSS  help files, (see also  \url{http://www.gamlss.org/}) 

}
\author{
Mikis Stasinopoulos \email{d.stasinopoulos@londonmet.ac.uk}
}
\note{
In predicting from a fitted \code{FixBreakPointsReg} or \code{FreeBreakPointsReg} model there are two choices 
to be made:  
The first is to create new end-points for all the x-variables including the \code{newdata}. Note that in this case 
the range of x  could be bigger that the original one if \code{newdata} has values outside the original x range.  
The second is to have the old data end-points which were determine with the original range of x.
The second choice is implemented as a default in the \code{predict} method for \code{FixBreakPointsReg} and
\code{FreeBreakPointsReg} objects with  the argument \code{old.x.range=TRUE}. Values outside the original x-range 
in this case will be the determined by the global polynomial fitted to data.  
If the argument of predict is set to  \code{old.x.range=FALSE} the prediction could be possible 
better outside the x range but would not coincide with the original predictions i.e. fitted(model)
since the Beta-spline base has changed.
}

%% ~Make other sections like Warning with \section{Warning }{....} ~


\examples{
# creating  a linear + linear function
   x <- seq(0,10, length.out=201)
knot <- 5
 set.seed(12543)
 mu <- ifelse(x<=knot,5+0.5*x,5+0.5*x+(x-knot))
  y <- rNO(201, mu=mu, sigma=.5)
# plot the data
 plot(y~x, xlim=c(-1,13), ylim=c(3,17))
# fit model using fixed break points
 m1 <- fitFixBP(x, y, knots=5, degree=1)
knots(m1)
lines(fitted(m1)~x, col="red")
m2 <- fitFreeKnots(x, y, knots=5, degree=1)
knots(m2)
lines(fitted(m2)~x, col="green", lwd=3)
points(0:13,predict(m2, newdata=0:13), col="red",pch = 21, bg="blue")
points(0:13,predict(m2, newdata=0:13, old.x.range=FALSE), col="red",pch = 21, bg="grey")
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{regression}
