% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/games_ga.R
\name{games_ga}
\alias{games_ga}
\title{Games genetic algorithm:}
\usage{
games_ga(CC = 3, CD = 0, DC = 5, DD = 1, callC = TRUE,
  generations = 250, rounds = 100, num_opponents = 100,
  cross_prob = 0.05, mutation_prob = 0.05)
}
\arguments{
\item{CC}{The number of points awarded to a focal agent when the focal agent 
and its opponent both cooperate}

\item{CD}{The number of points awarded to a focal agent when the focal agent
cooperates and its opponent defects}

\item{DC}{The number of points awarded to a focal agent when the focal agent
defects and its opponent cooperates}

\item{DD}{The number of points awarded to a focal agent when the focal agent
and its opponent both defect}

\item{callC}{Whether or not the function calls c in the genetic algorithm. 
While not calling c is an option, the default value is TRUE because using the
compiled c code greatly speeds up the genetic algorithm, making the whole
program run much faster}

\item{generations}{The number of generations the genetic algorithm will run
before returning selected genotypes and fitness history. Each generation 
includes some number of rounds of the game that each strategy will play}

\item{rounds}{The number of rounds of the game that a focal player will play
against its opponent before moving on to the next opponent. Rounds are played
iteratively against opponents, allowing the history of interactions to affect
strategies and therefore total payoffs after all rounds are completed}

\item{num_opponents}{The number of randomly selected opponents that a focal
player will play during the course of one generation; the focal player will
play in the same number of rounds with each opponent}

\item{cross_prob}{A uniform probability of random crossing over event for a 
focal player's locus with the same locus from another randomly selected 
player.}

\item{mutation_prob}{The probability that a given locus will mutate; mutation
from `C` to `D` occurs with the same probability as `D` to `C` (no bias)}
}
\value{
A list, the elements of which include: 1. A table of the genomes
of strategies and their frequencies in the population and 2. The mean
fitness calculated over all players population in each generation. Fitness of
one player is the number of points accrued over all rounds and opponents in a
generation.
}
\description{
This function runs a genetic algorithm that identifies sequential strategies 
for maximising payoffs given any two by two symmetrical payoff matrix. 
Simulated players remember three rounds into the past.
}
\examples{
games_ga(CC = 3, CD = 0, DC = 5, DD = 1, generations = 100, rounds = 100)
}
