% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projects.R
\name{get_project_types}
\alias{get_project_types}
\title{Retrieve Highbond Projects - Project Types}
\usage{
get_project_types(
  auth,
  project_type_id = NULL,
  fields = NULL,
  pagesize = 50,
  waittime = 0.2
)
}
\arguments{
\item{auth}{Highbond authentication credentials, created from \code{\link{setup_highbond}}}

\item{project_type_id}{\code{NULL} Defaults to all project types}

\item{fields}{OPTIONAL. A character vector each field requested within the
project. NULL will default to all fields.}

\item{pagesize}{Defaults to 50. Maximum is 100.}

\item{waittime}{Time in seconds to wait between requests.}
}
\value{
A tibble of project types
}
\description{
Downloads the primary details of one or all project types.
}
\details{
Possible fields include: name, description, workflow, project_terms,
certification_terms, control_terms, finding_terms, control_test_terms,
finding_action_terms, narrative_terms, objective_terms, planning_terms,
results_terms, risk_terms, test_plan_terms, walkthrough_terms
}
