%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Do not modify this file since it was automatically generated from:
% 
%  
% 
% on Wed Feb 08 14:37:32 2006.
% 
% Generator was the Rdoc class, which is part of the R.oo package written
% by Henrik Bengtsson, 2001-2004.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

 \name{newRandomCollection.Gene}
\alias{newRandomCollection.Gene}
\alias{Gene.newRandomCollection}
\alias{newRandomCollection.Gene}
\alias{newRandomCollection,Gene-method}
\keyword{methods}
\keyword{internal}


 \title{Generates a list of cloned objects and random values}

 \description{
  Creates a list of cloned objects with its internal values generated by random.
 }

 \usage{\method{newRandomCollection}{Gene}(.O, ...)}

 \arguments{
   \item{n}{Number of object clones.}
 }

 \value{
  Returns a list with cloned objects and random generated values.
 }

 \details{
  For all cloned objects, \code{generateRandom} method is called. This has no effect for common \code{Gene} objects since the generated value is not stored there. However, this mechanism works equally well when it is needed to store values in \code{Gene}.
 }

 \examples{
   ge <- Gene(shape1=1, shape2=100)
   ge
   print(ge)
   # list of five new different Gene objects
   newRandomCollection(ge, 5)
   # list of two new different Gene objects converted to a list using unObject
   unObject(newRandomCollection(ge,2))
 
   # building chromosome from gene clones
   # (perhaps for variable selection in microarray data)
   cr <- Chromosome(genes=newRandomCollection(ge, 5))
   cr
 }

 \references{Goldberg, David E. 1989 \emph{Genetic Algorithms in Search, Optimization and Machine Learning}. Addison-Wesley Pub. Co. ISBN: 0201157675}

 \author{Victor Trevino. Francesco Falciani Group. University of Birmingham, U.K. http://www.bip.bham.ac.uk/bioinf}

 \seealso{
   For more information see \code{\link{Gene}}.
   \code{\link{unObject}},
   \code{\link{as.list.Object}},
   \code{\link{newCollection.Chromosome}},
   \code{\link{Chromosome}}.
 }

 \keyword{methods}
