#' @rdname atlas_
#' @order 2
#' @param group_by `tibble`: generated by a call to [galah_group_by()].
#' @param limit `numeric`: maximum number of categories to return, defaulting to 100.
#' If limit is NULL, all results are returned. For some categories this will
#' take a while.
#' @param type `string`: one of `"occurrences"` or `"species"`. 
#' Defaults to `"occurrences"`, which returns the number of records
#' that match the selected criteria; alternatively returns the number of 
#' species. Formerly accepted arguments (`"records"` or `"species"`) are
#' deprecated but remain functional.
#' @export
atlas_counts <- function(request = NULL, 
                         identify = NULL, 
                         filter = NULL, 
                         geolocate = NULL,
                         data_profile = NULL,
                         group_by = NULL, 
                         limit = NULL,
                         type = c("occurrences", "species")
                         ) {
  # capture supplied arguments
  args <- as.list(environment())
  args$type <- match.arg(type)
  dr <- check_atlas_inputs(args) # convert to `data_request` object
  # check for outdated naming conventions
  if(dr$type == "record"){dr$type <- "occurrences"}
  # pass to collect etc
  dr |> 
    count() |>
    slice_head(n = limit) |>
    collect()
}