% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify.R
\name{identify.data_request}
\alias{identify.data_request}
\title{Narrow a query by passing taxonomic identifiers}
\usage{
\method{identify}{data_request}(x, ..., search = TRUE)
}
\arguments{
\item{x}{An object of class \code{data_request}, created using \code{\link[=galah_call]{galah_call()}}}

\item{...}{one or more scientific names (if \code{search = TRUE}) or taxonomic
identifiers (if \code{search = FALSE}); or an object of class \code{ala_id} (from
\code{search_taxa}).}

\item{search}{(logical); should the results in question be passed to
\code{search_taxa}?}
}
\value{
A tibble containing identified taxa.
}
\description{
When conducting a search or creating a data query, it is common to identify
a known taxon or group of taxa to narrow down the records or results returned.
}
\details{
\code{galah_identify()} is used to identify taxa you want returned in a search or
a data query. Users to pass scientific names or taxonomic identifiers
with pipes to provide data only for the biological group of interest.

It is good to use \code{\link[=search_taxa]{search_taxa()}} and \code{\link[=search_identifiers]{search_identifiers()}}
first to check that the taxa you provide to \code{galah_identify()} return the
correct results.
}
\seealso{
\code{\link[=galah_identify]{galah_identify()}}, with which this function is synonymous;
\code{\link[=search_taxa]{search_taxa()}} to find identifiers from scientific names;
\code{\link[=search_identifiers]{search_identifiers()}} for how to get names if taxonomic identifiers
are already known.
}
