% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galah_down_to.R
\name{galah_down_to}
\alias{galah_down_to}
\title{Specify the lowest taxonomic rank required in a downwards search}
\usage{
galah_down_to(...)
}
\arguments{
\item{...}{the name of a single taxonomic rank}
}
\value{
A string with the named rank
}
\description{
\code{atlas_taxonomy} generates a downwards search of the taxonomic tree. Use
\code{galah_down_to()} to specify the taxonomic level to search to.
\code{galah_down_to()} uses non-standard evaluation (NSE).
}
\examples{
\dontrun{
# Return a taxonomic tree of *Chordata* down to the class level
galah_call() |>
    galah_identify("Vertebrata") |>
    galah_down_to(class) |>
    atlas_taxonomy()
}
}
\seealso{
\code{\link[=galah_select]{galah_select()}}, \code{\link[=galah_filter]{galah_filter()}} and
\code{\link[=galah_geolocate]{galah_geolocate()}} for related methods.
}
