/*
 * Decompiled with CFR 0.152.
 */
package gWidgetsrJava;

import gWidgetsrJava.DateSpan;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class JXMonthView
extends JComponent {
    public static final int NO_SELECTION = 0;
    public static final int SINGLE_SELECTION = 1;
    public static final int MULTIPLE_SELECTION = 2;
    public static final int WEEK_SELECTION = 3;
    protected Insets _monthStringInsets = new Insets(0, 8, 0, 8);
    private static final int MONTH_DROP_SHADOW = 1;
    private static final int MONTH_LINE_DROP_SHADOW = 2;
    private static final int WEEK_DROP_SHADOW = 4;
    private int _boxPaddingX = 3;
    private int _boxPaddingY = 3;
    private static final int CALENDAR_SPACING = 10;
    private static final int DAYS_IN_WEEK = 7;
    private static final int MONTHS_IN_YEAR = 12;
    private long _firstDisplayedDate;
    private int _firstDisplayedMonth;
    private int _firstDisplayedYear;
    private long _lastDisplayedDate;
    private Font _derivedFont;
    private long _startSelectedDate = -1L;
    private long _endSelectedDate = -1L;
    private long _pivotDate = -1L;
    private Rectangle _selectedDateRect = new Rectangle();
    private int _numCalCols = 1;
    private int _numCalRows = 1;
    private int _minCalCols = 1;
    private int _minCalRows = 1;
    private long _today;
    private long[] _flaggedDates;
    private int _selectionMode = 1;
    private int _boxHeight;
    private int _boxWidth;
    private int _calendarWidth;
    private int _calendarHeight;
    private int _firstDayOfWeek = 1;
    private int _startX;
    private int _startY;
    private int _dropShadowMask = 1;
    private boolean _dirty = false;
    private boolean _antiAlias = false;
    private boolean _ltr;
    private boolean _asKirkWouldSay_FIRE = false;
    private Calendar _cal;
    private String[] _daysOfTheWeek;
    private static String[] _monthsOfTheYear;
    private Dimension _dim = new Dimension();
    private Rectangle _bounds = new Rectangle();
    private Rectangle _dirtyRect = new Rectangle();
    private Color _todayBackgroundColor;
    private Color _monthStringBackground = Color.LIGHT_GRAY;
    private Color _selectedBackground = Color.LIGHT_GRAY;
    private SimpleDateFormat _dayOfMonthFormatter = new SimpleDateFormat("d");
    private String _actionCommand = "selectionChanged";
    private Timer _todayTimer = null;

    public JXMonthView() {
        this(new Date().getTime());
    }

    public JXMonthView(long l) {
        this._ltr = this.getComponentOrientation().isLeftToRight();
        this._cal = Calendar.getInstance(this.getLocale());
        this._cal.setFirstDayOfWeek(this._firstDayOfWeek);
        this._cal.set(11, 0);
        this._cal.set(12, 0);
        this._cal.set(13, 0);
        this._cal.set(14, 0);
        this._today = this._cal.getTimeInMillis();
        this._cal.setTimeInMillis(l);
        this.setFirstDisplayedDate(this._cal.getTimeInMillis());
        this._cal.set(2, this._cal.getMinimum(2));
        this._cal.set(5, this._cal.getActualMinimum(5));
        _monthsOfTheYear = new String[12];
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMM");
        for (int i = 0; i < 12; ++i) {
            JXMonthView._monthsOfTheYear[i] = simpleDateFormat.format(this._cal.getTime());
            this._cal.add(2, 1);
        }
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.setFont(new Font("Dialog", 0, 12));
        this._todayBackgroundColor = this.getForeground();
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.updateUI();
    }

    public void updateUI() {
        super.updateUI();
        String[] stringArray = (String[])UIManager.get("JXMonthView.daysOfTheWeek");
        if (stringArray == null) {
            stringArray = new String[]{"S", "M", "T", "W", "R", "F", "S"};
        }
        this.setDaysOfTheWeek(stringArray);
        Color color = UIManager.getColor("JXMonthView.monthStringBackground");
        if (color == null) {
            color = Color.LIGHT_GRAY;
        }
        this.setMonthStringBackground(color);
        color = UIManager.getColor("JXMonthView.selectedBackground");
        if (color == null) {
            color = Color.LIGHT_GRAY;
        }
        this.setSelectedBackground(color);
    }

    public long getFirstDisplayedDate() {
        return this._firstDisplayedDate;
    }

    public void setFirstDisplayedDate(long l) {
        long l2 = this._firstDisplayedDate;
        this._cal.setTimeInMillis(l);
        this._cal.set(5, 1);
        this._cal.set(11, 0);
        this._cal.set(12, 0);
        this._cal.set(13, 0);
        this._cal.set(14, 0);
        this._firstDisplayedDate = this._cal.getTimeInMillis();
        this._firstDisplayedMonth = this._cal.get(2);
        this._firstDisplayedYear = this._cal.get(1);
        this.calculateLastDisplayedDate();
        this.firePropertyChange("firstDisplayedDate", l2, this._firstDisplayedDate);
        this.repaint();
    }

    public long getLastDisplayedDate() {
        return this._lastDisplayedDate;
    }

    private void calculateLastDisplayedDate() {
        long l = this._lastDisplayedDate;
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        this._cal.add(2, this._numCalCols * this._numCalRows - 1);
        this._cal.set(5, this._cal.getActualMaximum(5));
        this._cal.set(11, 23);
        this._cal.set(12, 59);
        this._cal.set(13, 59);
        this._lastDisplayedDate = this._cal.getTimeInMillis();
        this.firePropertyChange("lastDisplayedDate", l, this._lastDisplayedDate);
    }

    public void ensureDateVisible(long l) {
        if (l < this._firstDisplayedDate) {
            this.setFirstDisplayedDate(l);
        } else if (l > this._lastDisplayedDate) {
            this._cal.setTimeInMillis(l);
            int n = this._cal.get(2);
            int n2 = this._cal.get(1);
            this._cal.setTimeInMillis(this._lastDisplayedDate);
            int n3 = this._cal.get(2);
            int n4 = this._cal.get(1);
            int n5 = n - n3 + (n2 - n4) * 12;
            this._cal.setTimeInMillis(this._firstDisplayedDate);
            this._cal.add(2, n5);
            this.setFirstDisplayedDate(this._cal.getTimeInMillis());
        }
        if (this._startSelectedDate != -1L || this._endSelectedDate != -1L) {
            this.calculateDirtyRectForSelection();
        }
    }

    public DateSpan getSelectedDateSpan() {
        DateSpan dateSpan = null;
        if (this._startSelectedDate != -1L) {
            dateSpan = new DateSpan(new Date(this._startSelectedDate), new Date(this._endSelectedDate));
        }
        return dateSpan;
    }

    public void setSelectedDateSpan(DateSpan dateSpan) {
        DateSpan dateSpan2 = null;
        if (this._startSelectedDate != -1L && this._endSelectedDate != -1L) {
            dateSpan2 = new DateSpan(this._startSelectedDate, this._endSelectedDate);
        }
        if (dateSpan == null) {
            this._startSelectedDate = -1L;
            this._endSelectedDate = -1L;
        } else {
            this._cal.setTimeInMillis(dateSpan.getStart());
            this._cal.set(11, 0);
            this._cal.set(12, 0);
            this._cal.set(13, 0);
            this._cal.set(14, 0);
            this._startSelectedDate = this._cal.getTimeInMillis();
            if (this._selectionMode == 1) {
                this._endSelectedDate = this._startSelectedDate;
            } else {
                this._cal.setTimeInMillis(dateSpan.getEnd());
                this._cal.set(11, 0);
                this._cal.set(12, 0);
                this._cal.set(13, 0);
                this._cal.set(14, 0);
                this._endSelectedDate = this._cal.getTimeInMillis();
                if (this._selectionMode == 3) {
                    this._cal.setTimeInMillis(this._startSelectedDate);
                    int n = 1;
                    while (this._cal.getTimeInMillis() < this._endSelectedDate) {
                        this._cal.add(5, 1);
                        ++n;
                    }
                    if (n > 7) {
                        int n2;
                        this._cal.setTimeInMillis(this._startSelectedDate);
                        int n3 = this._cal.get(7);
                        if (n3 != this._firstDayOfWeek) {
                            n2 = n3 - this._firstDayOfWeek;
                            if (n2 < 0) {
                                n2 += 7;
                            }
                            this._cal.add(5, -n2);
                            n += n2;
                            this._startSelectedDate = this._cal.getTimeInMillis();
                        }
                        if ((n2 = n % 7) != 0) {
                            this._cal.setTimeInMillis(this._endSelectedDate);
                            this._cal.add(5, 7 - n2);
                            this._endSelectedDate = this._cal.getTimeInMillis();
                        }
                    }
                }
            }
            this._cal.setTimeInMillis(this._firstDisplayedDate);
        }
        this.repaint(this._dirtyRect);
        this.calculateDirtyRectForSelection();
        this.repaint(this._dirtyRect);
        this.firePropertyChange("selectedDates", dateSpan2, dateSpan);
    }

    public int getSelectionMode() {
        return this._selectionMode;
    }

    public void setSelectionMode(int n) throws IllegalArgumentException {
        if (n != 1 && n != 2 && n != 3 && n != 0) {
            throw new IllegalArgumentException(n + " is not a valid selection mode");
        }
        this._selectionMode = n;
    }

    public void setFlaggedDates(long[] lArray) {
        this._flaggedDates = lArray;
        if (this._flaggedDates == null) {
            this.repaint();
            return;
        }
        for (int i = 0; i < this._flaggedDates.length; ++i) {
            this._cal.setTimeInMillis(this._flaggedDates[i]);
            this._cal.set(11, 0);
            this._cal.set(12, 0);
            this._cal.set(13, 0);
            this._cal.set(14, 0);
            this._flaggedDates[i] = this._cal.getTimeInMillis();
        }
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        this.repaint();
    }

    public int getBoxPaddingX() {
        return this._boxPaddingX;
    }

    public void setBoxPaddingX(int n) {
        this._boxPaddingX = n;
        this._dirty = true;
    }

    public int getBoxPaddingY() {
        return this._boxPaddingY;
    }

    public void setBoxPaddingY(int n) {
        this._boxPaddingY = n;
        this._dirty = true;
    }

    public void setDaysOfTheWeek(String[] stringArray) throws IllegalArgumentException, NullPointerException {
        if (stringArray == null) {
            throw new NullPointerException("Array of days is null.");
        }
        if (stringArray.length != 7) {
            throw new IllegalArgumentException("Array of days is not of length 7 as expected.");
        }
        this._daysOfTheWeek = stringArray;
    }

    public String[] getDaysOfTheWeek() {
        String[] stringArray = new String[7];
        System.arraycopy(this._daysOfTheWeek, 0, stringArray, 0, 7);
        return stringArray;
    }

    public int getFirstDayOfWeek() {
        return this._firstDayOfWeek;
    }

    public void setFirstDayOfWeek(int n) {
        if (n == this._firstDayOfWeek) {
            return;
        }
        this._firstDayOfWeek = n;
        this._cal.setFirstDayOfWeek(this._firstDayOfWeek);
        this.repaint();
    }

    public TimeZone getTimeZone() {
        return this._cal.getTimeZone();
    }

    public void setTimeZone(TimeZone timeZone) {
        this._cal.setTimeZone(timeZone);
    }

    public boolean getAntialiased() {
        return this._antiAlias;
    }

    public void setAntialiased(boolean bl) {
        if (this._antiAlias == bl) {
            return;
        }
        this._antiAlias = bl;
        this.repaint();
    }

    public Color getSelectedBackground() {
        return this._selectedBackground;
    }

    public void setSelectedBackground(Color color) {
        this._selectedBackground = color;
    }

    public Color getTodayBackground() {
        return this._todayBackgroundColor;
    }

    public void setTodayBackground(Color color) {
        this._todayBackgroundColor = color;
        this.repaint();
    }

    public Color getMonthStringBackground() {
        return this._monthStringBackground;
    }

    public void setMonthStringBackground(Color color) {
        this._monthStringBackground = color;
        this.repaint();
    }

    public Insets getMonthStringInsets() {
        return (Insets)this._monthStringInsets.clone();
    }

    public void setMonthStringInsets(Insets insets) {
        if (insets == null) {
            this._monthStringInsets.top = 0;
            this._monthStringInsets.left = 0;
            this._monthStringInsets.bottom = 0;
            this._monthStringInsets.right = 0;
        } else {
            this._monthStringInsets.top = insets.top;
            this._monthStringInsets.left = insets.left;
            this._monthStringInsets.bottom = insets.bottom;
            this._monthStringInsets.right = insets.right;
        }
        this.repaint();
    }

    public int getPreferredCols() {
        return this._minCalCols;
    }

    public void setPreferredCols(int n) {
        if (n <= 0) {
            return;
        }
        this._minCalCols = n;
        this._dirty = true;
        this.revalidate();
        this.repaint();
    }

    public int getPreferredRows() {
        return this._minCalRows;
    }

    public void setPreferredRows(int n) {
        if (n <= 0) {
            return;
        }
        this._minCalRows = n;
        this._dirty = true;
        this.revalidate();
        this.repaint();
    }

    private void updateIfNecessary() {
        if (this._dirty) {
            this.update();
            this._dirty = false;
        }
    }

    private void update() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        this._derivedFont = this.getFont().deriveFont(1);
        FontMetrics fontMetrics = this.getFontMetrics(this._derivedFont);
        this._cal.set(2, this._cal.getMinimum(2));
        this._cal.set(5, this._cal.getActualMinimum(5));
        for (n2 = 0; n2 < this._cal.getMaximum(2); ++n2) {
            int n6;
            n = fontMetrics.stringWidth(_monthsOfTheYear[n2]);
            if (n > n5) {
                n5 = n;
            }
            if ((n6 = this._cal.getActualMaximum(5)) > n4) {
                n3 = this._cal.get(2);
                n4 = n6;
            }
            this._cal.add(2, 1);
        }
        this._cal.set(2, n3);
        this._cal.set(5, this._cal.getActualMinimum(5));
        this._boxHeight = fontMetrics.getHeight();
        for (n2 = 0; n2 < n4; ++n2) {
            n = fontMetrics.stringWidth(this._dayOfMonthFormatter.format(this._cal.getTime()));
            if (n > this._boxWidth) {
                this._boxWidth = n;
            }
            this._cal.add(5, 1);
        }
        this._dim.width = (this._boxWidth + 2 * this._boxPaddingX) * 7;
        if (this._dim.width < n5) {
            double d = n5 - this._dim.width;
            this._boxWidth = (int)((double)this._boxWidth + Math.ceil(d / 7.0));
            this._dim.width = (this._boxWidth + 2 * this._boxPaddingX) * 7;
        }
        this._calendarWidth = (this._boxWidth + 2 * this._boxPaddingX) * 7;
        this._calendarHeight = (this._boxPaddingY + this._boxHeight + this._boxPaddingY) * 8;
        this._dim.height = this._calendarHeight * this._minCalRows + 10 * (this._minCalRows - 1);
        this._dim.width = this._calendarWidth * this._minCalCols + 10 * (this._minCalCols - 1);
        Insets insets = this.getInsets();
        this._dim.width += insets.left + insets.right;
        this._dim.height += insets.top + insets.bottom;
        this._cal.setTimeInMillis(this._firstDisplayedDate);
    }

    private void updateToday() {
        this._cal.setTimeInMillis(this._today);
        this._cal.add(5, 1);
        this._today = this._cal.getTimeInMillis();
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        this.repaint();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        this.updateIfNecessary();
        return new Dimension(this._dim);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void setBorder(Border border) {
        super.setBorder(border);
        this.calculateNumDisplayedCals();
        this.calculateStartPosition();
        this._dirty = true;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.calculateNumDisplayedCals();
        this.calculateStartPosition();
        if (this._startSelectedDate != -1L || this._endSelectedDate != -1L) {
            if (this._startSelectedDate > this._lastDisplayedDate || this._startSelectedDate < this._firstDisplayedDate) {
                this.ensureDateVisible(this._startSelectedDate);
            } else {
                this.calculateDirtyRectForSelection();
            }
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        super.setComponentOrientation(componentOrientation);
        this._ltr = componentOrientation.isLeftToRight();
        this.calculateStartPosition();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this._dirty = true;
    }

    public void removeNotify() {
        this._todayTimer.stop();
        super.removeNotify();
    }

    public void addNotify() {
        super.addNotify();
        int n = 86400;
        if (this._todayTimer == null) {
            this._todayTimer = new Timer(n * 1000, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JXMonthView.this.updateToday();
                }
            });
        }
        this._cal.setTimeInMillis(System.currentTimeMillis());
        n = n - this._cal.get(11) * 3600 - this._cal.get(12) * 60 - this._cal.get(13);
        this._todayTimer.setInitialDelay(n * 1000);
        this._todayTimer.start();
        this._cal.setTimeInMillis(this._firstDisplayedDate);
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D;
        Object object = null;
        Graphics2D graphics2D2 = graphics2D = graphics instanceof Graphics2D ? (Graphics2D)graphics : null;
        if (graphics2D != null && this._antiAlias) {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        Rectangle rectangle = graphics.getClipBounds();
        this.updateIfNecessary();
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        graphics.setColor(this.getForeground());
        Color color = graphics.getColor();
        color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 51);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        int n = this._startY;
        for (int i = 0; i < this._numCalRows; ++i) {
            int n2 = this._startX;
            this._bounds.x = 0;
            this._bounds.y = this._startY + i * (this._calendarHeight + 10);
            this._bounds.width = this.getWidth();
            this._bounds.height = this._calendarHeight;
            if (!this._bounds.intersects(rectangle)) {
                this._cal.add(2, this._numCalCols);
                n += this._calendarHeight + 10;
                continue;
            }
            for (int j = 0; j < this._numCalCols; ++j) {
                int n3;
                int n4;
                String string = _monthsOfTheYear[this._cal.get(2)];
                string = string + " " + this._cal.get(1);
                this._bounds.x = this._ltr ? n2 : n2 - this._calendarWidth;
                this._bounds.y = n + this._boxPaddingY;
                this._bounds.width = this._calendarWidth;
                this._bounds.height = this._boxHeight;
                if (this._bounds.intersects(rectangle)) {
                    this.paintMonthStringBackground(graphics, this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height);
                    graphics.setColor(this.getForeground());
                    n4 = this._ltr ? n2 + this._calendarWidth / 2 - fontMetrics.stringWidth(string) / 2 : n2 - this._calendarWidth / 2 - fontMetrics.stringWidth(string) / 2 - 1;
                    n3 = n + this._boxPaddingY + this._boxHeight - fontMetrics.getDescent();
                    graphics.drawString(string, n4, n3);
                    if ((this._dropShadowMask & 1) != 0) {
                        graphics.setColor(color);
                        graphics.drawString(string, n4 + 1, n3 + 1);
                        graphics.setColor(this.getForeground());
                    }
                }
                this._bounds.x = this._ltr ? n2 : n2 - this._calendarWidth;
                this._bounds.y = n + this._boxPaddingY + this._boxHeight + this._boxPaddingY + this._boxPaddingY;
                this._bounds.width = this._calendarWidth;
                this._bounds.height = this._boxHeight;
                if (this._bounds.intersects(rectangle)) {
                    this._cal.set(5, this._cal.getActualMinimum(5));
                    int n5 = this._firstDayOfWeek - 1;
                    for (int k = 0; k < 7; ++k) {
                        n4 = this._ltr ? n2 + k * (this._boxPaddingX + this._boxWidth + this._boxPaddingX) + this._boxPaddingX + this._boxWidth / 2 - fontMetrics.stringWidth(this._daysOfTheWeek[n5]) / 2 : n2 - k * (this._boxPaddingX + this._boxWidth + this._boxPaddingX) - this._boxPaddingX - this._boxWidth / 2 - fontMetrics.stringWidth(this._daysOfTheWeek[n5]) / 2;
                        n3 = n + this._boxPaddingY + this._boxHeight + this._boxPaddingY + this._boxPaddingY + fontMetrics.getAscent();
                        graphics.drawString(this._daysOfTheWeek[n5], n4, n3);
                        if ((this._dropShadowMask & 4) != 0) {
                            graphics.setColor(color);
                            graphics.drawString(this._daysOfTheWeek[n5], n4 + 1, n3 + 1);
                            graphics.setColor(this.getForeground());
                        }
                        if (++n5 != 7) continue;
                        n5 = 0;
                    }
                    graphics.drawLine(this._ltr ? n2 + 2 : n2 - 3, n + this._boxPaddingY * 3 + this._boxHeight * 2, this._ltr ? n2 + this._calendarWidth - 3 : n2 - this._calendarWidth + 2, n + this._boxPaddingY * 3 + this._boxHeight * 2);
                    if ((this._dropShadowMask & 2) != 0) {
                        graphics.setColor(color);
                        graphics.drawLine(this._ltr ? n2 + 3 : n2 - 2, n + this._boxPaddingY * 3 + this._boxHeight * 2 + 1, this._ltr ? n2 + this._calendarWidth - 2 : n2 - this._calendarWidth + 3, n + this._boxPaddingY * 3 + this._boxHeight * 2 + 1);
                        graphics.setColor(this.getForeground());
                    }
                }
                this._bounds.x = this._startX + (this._ltr ? j * (this._calendarWidth + 10) : -(j * (this._calendarWidth + 10) + this._calendarWidth));
                this._bounds.y = this._startY + i * (this._calendarHeight + 10);
                this._bounds.width = this._calendarWidth;
                this._bounds.height = this._calendarHeight;
                if (this._bounds.intersects(rectangle)) {
                    this.paintMonth(graphics, j, i);
                } else {
                    this._cal.add(2, 1);
                }
                n2 += this._ltr ? this._calendarWidth + 10 : -(this._calendarWidth + 10);
            }
            n += this._calendarHeight + 10;
        }
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        if (graphics2D != null && this._antiAlias) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        }
    }

    private void paintMonth(Graphics graphics, int n, int n2) {
        int n3 = this._cal.getActualMaximum(5);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle rectangle = graphics.getClipBounds();
        long l = -1L;
        int n4 = 0;
        if (this._flaggedDates != null && this._flaggedDates.length > 0) {
            l = this._flaggedDates[n4];
        }
        for (int i = 0; i < n3; ++i) {
            this.calculateBoundsForDay(this._bounds);
            if (this._bounds.intersects(rectangle)) {
                String string = this._dayOfMonthFormatter.format(this._cal.getTime());
                if (this.isSelectedDate(this._cal.getTimeInMillis())) {
                    if (this._selectionMode == 1) {
                        this._dirtyRect.x = this._bounds.x;
                        this._dirtyRect.y = this._bounds.y;
                        this._dirtyRect.width = this._bounds.width;
                        this._dirtyRect.height = this._bounds.height;
                    }
                    this.paintSelectedDayBackground(graphics, this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height);
                    graphics.setColor(this.getForeground());
                }
                if (this._cal.getTimeInMillis() == this._today) {
                    this.paintTodayBackground(graphics, this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height);
                    graphics.setColor(this.getForeground());
                }
                while (l != -1L && l < this._cal.getTimeInMillis()) {
                    if (++n4 < this._flaggedDates.length) {
                        l = this._flaggedDates[n4];
                        continue;
                    }
                    l = -1L;
                }
                if (l != -1L && this._cal.getTimeInMillis() == l) {
                    Font font = this.getFont();
                    graphics.setFont(this._derivedFont);
                    graphics.drawString(string, this._ltr ? this._bounds.x + this._boxPaddingX + this._boxWidth - fontMetrics.stringWidth(string) : this._bounds.x + this._boxPaddingX + this._boxWidth - fontMetrics.stringWidth(string) - 1, this._bounds.y + this._boxPaddingY + fontMetrics.getAscent());
                    graphics.setFont(font);
                } else {
                    graphics.drawString(string, this._ltr ? this._bounds.x + this._boxPaddingX + this._boxWidth - fontMetrics.stringWidth(string) : this._bounds.x + this._boxPaddingX + this._boxWidth - fontMetrics.stringWidth(string) - 1, this._bounds.y + this._boxPaddingY + fontMetrics.getAscent());
                }
            }
            this._cal.add(5, 1);
        }
    }

    protected void paintMonthStringBackground(Graphics graphics, int n, int n2, int n3, int n4) {
        n = this._ltr ? n + this._monthStringInsets.left : n + this._monthStringInsets.left;
        n3 = n3 - this._monthStringInsets.left - this._monthStringInsets.right;
        n4 = n4 - this._monthStringInsets.top - this._monthStringInsets.bottom;
        graphics.setColor(this._monthStringBackground);
        graphics.fillRect(n, n2 += this._monthStringInsets.top, n3, n4);
    }

    protected void paintTodayBackground(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(this._todayBackgroundColor);
        graphics.drawRect(n, n2, n3 - 1, n4 - 1);
    }

    protected void paintSelectedDayBackground(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(this.getSelectedBackground());
        graphics.fillRect(n, n2, n3, n4);
    }

    private boolean isSelectedDate(long l) {
        return l >= this._startSelectedDate && l <= this._endSelectedDate;
    }

    private void calculateNumDisplayedCals() {
        int n = this._numCalCols;
        int n2 = this._numCalRows;
        this._numCalCols = 1;
        this._numCalCols += (this.getWidth() - this._calendarWidth) / (this._calendarWidth + 10);
        this._numCalRows = 1;
        this._numCalRows += (this.getHeight() - this._calendarHeight) / (this._calendarHeight + 10);
        if (n != this._numCalCols || n2 != this._numCalRows) {
            this.calculateLastDisplayedDate();
        }
    }

    private void calculateStartPosition() {
        this._startX = (this.getWidth() - (this._calendarWidth * this._numCalCols + 10 * (this._numCalCols - 1))) / 2;
        if (!this._ltr) {
            this._startX = this.getWidth() - this._startX;
        }
        this._startY = (this.getHeight() - (this._calendarHeight * this._numCalRows + 10 * (this._numCalRows - 1))) / 2;
    }

    private void calculateBoundsForDay(Rectangle rectangle) {
        int n = this._cal.get(1);
        int n2 = this._cal.get(2);
        int n3 = this._cal.get(7);
        int n4 = this._cal.get(4);
        int n5 = n2 - this._firstDisplayedMonth + (n - this._firstDisplayedYear) * 12;
        int n6 = n5 / this._numCalCols;
        int n7 = n5 - n6 * this._numCalCols;
        rectangle.x = n3 - this._firstDayOfWeek;
        if (rectangle.x < 0) {
            rectangle.x += 7;
        }
        rectangle.x = this._ltr ? rectangle.x * (this._boxPaddingX + this._boxWidth + this._boxPaddingX) : (rectangle.x + 1) * (this._boxPaddingX + this._boxWidth + this._boxPaddingX);
        rectangle.x += n7 * (this._calendarWidth + 10);
        rectangle.x = this._ltr ? this._startX + rectangle.x : this._startX - rectangle.x;
        rectangle.y = 2 * (this._boxPaddingY + this._boxHeight + this._boxPaddingY);
        rectangle.y += this._startY + n6 * (this._calendarHeight + 10);
        rectangle.y += (n4 - 1) * (this._boxPaddingY + this._boxHeight + this._boxPaddingY);
        rectangle.width = this._boxPaddingX + this._boxWidth + this._boxPaddingX;
        rectangle.height = this._boxPaddingY + this._boxHeight + this._boxPaddingY;
    }

    public long getDayAt(int n, int n2) {
        int n3;
        if (this._ltr ? this._startX > n : this._startX < n || this._startY > n2) {
            return -1L;
        }
        int n4 = (this._ltr ? n - this._startX : this._startX - n) / (this._calendarWidth + 10);
        int n5 = (n2 - this._startY) / (this._calendarHeight + 10);
        if (n5 > this._numCalRows - 1 || n4 > this._numCalCols - 1) {
            return -1L;
        }
        int n6 = (n2 - this._startY - n5 * (this._calendarHeight + 10)) / (this._boxPaddingY + this._boxHeight + this._boxPaddingY);
        if ((n6 -= 2) < 0 || n6 > 5) {
            return -1L;
        }
        int n7 = ((this._ltr ? n - this._startX : this._startX - n) - n4 * (this._calendarWidth + 10)) / (this._boxPaddingX + this._boxWidth + this._boxPaddingX);
        if (n7 > 6) {
            return -1L;
        }
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        this._cal.add(2, n4 + n5 * this._numCalCols);
        int n8 = this._cal.get(7);
        int n9 = n8 - this._firstDayOfWeek;
        if (n9 < 0) {
            n9 += 7;
        }
        if ((n3 = n6 * 7 + (n7 - n9)) < 0 || n3 > this._cal.getActualMaximum(5) - 1) {
            return -1L;
        }
        this._cal.add(5, n3);
        long l = this._cal.getTimeInMillis();
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        return l;
    }

    private void calculateDirtyRectForSelection() {
        if (this._startSelectedDate == -1L || this._endSelectedDate == -1L) {
            this._dirtyRect.x = 0;
            this._dirtyRect.y = 0;
            this._dirtyRect.width = 0;
            this._dirtyRect.height = 0;
        } else {
            this._cal.setTimeInMillis(this._startSelectedDate);
            this.calculateBoundsForDay(this._dirtyRect);
            this._cal.add(5, 1);
            while (this._cal.getTimeInMillis() <= this._endSelectedDate) {
                this.calculateBoundsForDay(this._bounds);
                Rectangle rectangle = this._dirtyRect.union(this._bounds);
                this._dirtyRect.x = rectangle.x;
                this._dirtyRect.y = rectangle.y;
                this._dirtyRect.width = rectangle.width;
                this._dirtyRect.height = rectangle.height;
                this._cal.add(5, 1);
            }
            this._cal.setTimeInMillis(this._firstDisplayedDate);
        }
    }

    public String getActionCommand() {
        return this._actionCommand;
    }

    public void setActionCommand(String string) {
        this._actionCommand = string;
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    protected void fireActionPerformed() {
        Object[] objectArray = this.listenerList.getListenerList();
        ActionEvent actionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            if (actionEvent == null) {
                actionEvent = new ActionEvent(this, 1001, this._actionCommand);
            }
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (!this.isEnabled() || this._selectionMode == 0) {
            return;
        }
        int n = mouseEvent.getID();
        if (n == 501) {
            int n2;
            int n3 = mouseEvent.getX();
            long l = this.getDayAt(n3, n2 = mouseEvent.getY());
            if (l == -1L) {
                return;
            }
            this._startSelectedDate = l;
            this._endSelectedDate = l;
            if (this._selectionMode == 2 || this._selectionMode == 3) {
                this._pivotDate = l;
            }
            this._cal.setTimeInMillis(l);
            this.calculateBoundsForDay(this._bounds);
            this._cal.setTimeInMillis(this._firstDisplayedDate);
            this.repaint(this._dirtyRect);
            this.repaint(this._bounds);
            this._dirtyRect.x = this._bounds.x;
            this._dirtyRect.y = this._bounds.y;
            this._dirtyRect.width = this._bounds.width;
            this._dirtyRect.height = this._bounds.height;
            this._asKirkWouldSay_FIRE = true;
        } else if (n == 502) {
            if (this._asKirkWouldSay_FIRE) {
                this.fireActionPerformed();
            }
            this._asKirkWouldSay_FIRE = false;
        }
        super.processMouseEvent(mouseEvent);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (!this.isEnabled() || this._selectionMode == 0) {
            return;
        }
        int n = mouseEvent.getID();
        if (n == 506) {
            int n2;
            int n3 = mouseEvent.getX();
            long l = this.getDayAt(n3, n2 = mouseEvent.getY());
            if (l == -1L) {
                return;
            }
            long l2 = this._startSelectedDate;
            long l3 = this._endSelectedDate;
            if (this._selectionMode == 1) {
                if (l == l2) {
                    return;
                }
                this._startSelectedDate = l;
                this._endSelectedDate = l;
            } else if (l <= this._pivotDate) {
                this._startSelectedDate = l;
                this._endSelectedDate = this._pivotDate;
            } else if (l > this._pivotDate) {
                this._startSelectedDate = this._pivotDate;
                this._endSelectedDate = l;
            }
            if (this._selectionMode == 3) {
                long l4 = l > this._pivotDate ? this._pivotDate : l;
                long l5 = l > this._pivotDate ? l : this._pivotDate;
                this._cal.setTimeInMillis(l4);
                int n4 = 1;
                while (this._cal.getTimeInMillis() < l5) {
                    this._cal.add(5, 1);
                    ++n4;
                }
                if (n4 > 7) {
                    int n5;
                    this._cal.setTimeInMillis(l4);
                    int n6 = this._cal.get(7);
                    int n7 = n6 - this._firstDayOfWeek;
                    if (n7 < 0) {
                        n7 += 7;
                    }
                    this._cal.add(5, -n7);
                    this._startSelectedDate = this._cal.getTimeInMillis();
                    this._cal.setTimeInMillis(l5);
                    n6 = this._cal.get(7);
                    int n8 = this._firstDayOfWeek - 1;
                    if (n8 == 0) {
                        n8 = 7;
                    }
                    if ((n5 = n8 - n6) < 0) {
                        n5 += 7;
                    }
                    this._cal.add(5, n5);
                    this._endSelectedDate = this._cal.getTimeInMillis();
                }
            }
            if (l2 == this._startSelectedDate && l3 == this._endSelectedDate) {
                return;
            }
            this.repaint(this._dirtyRect);
            this.calculateDirtyRectForSelection();
            this.repaint(this._dirtyRect);
            this._asKirkWouldSay_FIRE = true;
        }
        super.processMouseMotionEvent(mouseEvent);
    }
}

