% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{update-doc}
\alias{update-doc}
\alias{update.rcox}
\title{Update an RCOX model}
\arguments{
\item{object}{An RCOX model, an object of class RCOX}

\item{vcc}{Specification of the vertex colour classes in the model}

\item{ecc}{Specification of the edge colour classes in the model}

\item{splitvcc}{Existing vertex colour class to be split}

\item{splitecc}{Existing edge colour class to be split}

\item{joinvcc}{Existing vertex colour classes to be joined}

\item{joinecc}{Existing vertex colour classes to be joined}

\item{addecc}{New edge colour classes to be added}

\item{dropecc}{Existing vertex color classes to be dropped
(deleted)}

\item{Kstart}{A start value for K}

\item{fit}{Should the updated model be fitted.}

\item{control}{A list of control parameters.}

\item{trace}{For debugging purposes}

\item{...}{Additional arguments, currently not used.}
}
\value{
A new model object of class 'rcox'.
}
\description{
update will update and (by default) re-fit an RCOX
model.  It does this by extracting the call stored in the
object, updating the call and (by default) evaluating that
call. Sometimes it is useful to call update with only one
argument, for example if the data frame has been corrected
}
\section{Warning}{
 Only one of the arguments pertaining to edge
colour classes (i.e. ecc, splitecc, joinecc, dropecc, addecc)
should be applied at the time. Likewise for the arguments
pertaining to the vertex colour classes.

The result will otherwise be highly unpredictable and is likely to cause an
error.
}

\examples{


data(math)
gm  = ~al:an:st
vcc = list(~me+st, ~ve+an, ~al)
ecc = list(~me:ve+me:al, ~ve:al+al:st)

m1 <- rcox(gm=gm, vcc=vcc, ecc=ecc, data=math, method='matching', trace=0)

update(m1, joinvcc=list(~me+st, ~ve+an))
update(m1, joinecc=list(~al:an, ~an:st))

update(m1, splitvcc=~ve+an)
update(m1, splitecc=~me:ve+me:al)


update(m1, dropecc=list(~me:st+st:an,~al:an,~st:al))
update(m1, addecc=list(~an:me+st:ve))

}
\seealso{
\code{\link{rcox}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{models}
