## ----echo=FALSE-----------------------------------------------------------------------------------
require( gRbase )
prettyVersion <- packageDescription("gRbase")$Version
prettyDate <- format(Sys.Date())

## ----include=FALSE--------------------------------------------------------------------------------
library(knitr)
opts_chunk$set(
               fig.path='fig/graph',tidy=FALSE, 
               fig.height=2
)

## ----echo=FALSE, warning=FALSE------------------------------------------------
dir.create("fig")
oopt <- options()
options("digits"=4, "width"=80, "prompt"="R> ", "continue"="  ")
options(useFancyQuotes="UTF-8")

## ----echo=F-------------------------------------------------------------------
library(gRbase)
library(graph)
library(Rgraphviz)

## -----------------------------------------------------------------------------
uG11 <- ug( ~a:b + b:c:d)
uG12 <- ug( c("a", "b"), c("b", "c", "d") )
uG13 <- ug( list( c("a", "b"), c("b", "c", "d") ) )

## -----------------------------------------------------------------------------
uG11
nodes(uG11)
str( edges(uG11) )
plot( uG11 )

## -----------------------------------------------------------------------------
uG11m <- ug( ~a:b + b:c:d, result="matrix")
uG11M <- ug( ~a:b + b:c:d, result="dgCMatrix")

## -----------------------------------------------------------------------------
daG11 <- dag( ~a:b + b:c:d)
daG12 <- dag( c("a", "b"), c("b", "c", "d") )
daG13 <- dag( list( c("a", "b"), c("b", "c", "d") ) )

## -----------------------------------------------------------------------------
daG11
nodes( daG11 )
str( edges( daG11 ) )
plot( daG11 )

## -----------------------------------------------------------------------------
daG11m <- dag( ~a:b + b:c:d, result="matrix")
daG11M <- dag( ~a:b + b:c:d, result="dgCMatrix")

## -----------------------------------------------------------------------------
d1.bi <- dag(~a:b + b:a)
edgemode( d1.bi )
str( edges(d1.bi) )

## -----------------------------------------------------------------------------
d2.cyc <- dag(~a:b + b:c + c:a)

## -----------------------------------------------------------------------------
par(mfrow=c(1,2)); plot(d1.bi); plot(d2.cyc)

## ----results='markup', eval=F-------------------------------------------------
#  dag(~a:b + b:c + c:a, forceCheck=TRUE)

## -----------------------------------------------------------------------------
properties <- function(x){
  c(is_ug=is_ug(x), is_tug=is_tug(x), is_dg=is_dg(x), is_dag=is_dag(x),
    isD=graph::isDirected(x))
}
properties( uG11 )
properties( daG11 )
properties( d1.bi )
properties( d2.cyc )

## -----------------------------------------------------------------------------
mat <- as(uG11, "matrix")
Mat <- as(mat, "dgCMatrix")
NEL <- as(Mat, "graphNEL")

## -----------------------------------------------------------------------------
daG11.mor <- moralize(daG11)

## -----------------------------------------------------------------------------
par(mfrow=c(1,2)); plot(daG11); plot(daG11.mor)

## -----------------------------------------------------------------------------
moralize( daG11m, result="dgCMatrix" )

## -----------------------------------------------------------------------------
topo_sort(daG11)
topo_sort(daG11m)
topo_sort(daG11M)

## -----------------------------------------------------------------------------
topo_sort(dag(~a:b + b:c + c:a))

## -----------------------------------------------------------------------------
topo_sort( ug( ~a:b ) )

## -----------------------------------------------------------------------------
str( get_cliques(uG11) )
str( get_cliques(uG11m) )
str( get_cliques(uG11M) )

## -----------------------------------------------------------------------------
mcs(uG11)
mcs(uG11m)
mcs(uG11M)

## -----------------------------------------------------------------------------
mcs(uG11, root=c("a","c"))

## -----------------------------------------------------------------------------
mcs( daG11 )
mcs( as(daG11, "matrix") )

## -----------------------------------------------------------------------------
uG <- ug( ~a:b:c + c:d + d:e + a:e + f:g )
mcs(uG)
(tuG  <- triangulate(uG))
mcs(tuG)

## -----------------------------------------------------------------------------
(tuG  <- triangulate(uG))

## -----------------------------------------------------------------------------
par(mfrow=c(1,2)); plot(uG); plot(tuG)

## -----------------------------------------------------------------------------
rp <- rip(tuG); rp

## -----------------------------------------------------------------------------
plot(rp )

## -----------------------------------------------------------------------------
names(rp)
rp$nodes
rp$host
rp$children
str(rp$separators)

## -----------------------------------------------------------------------------
g1 <- ug(~a:b + b:c + c:d + d:e + e:f + a:f + b:e)
g1mt <- minimal_triang(g1) # A minimal triangulation

## -----------------------------------------------------------------------------
par(mfrow = c(1,2)); plot(g1); plot(g1mt)

## -----------------------------------------------------------------------------
g2 <- ug(~a:b:e:f + b:c:d:e)
g1mt2 <- minimal_triang(g1, tobject=g2)

## -----------------------------------------------------------------------------
par(mfrow = c(1,2)); plot(g2); plot(g1mt2)

## -----------------------------------------------------------------------------
mm <- mpd(g1); mm

## -----------------------------------------------------------------------------
par(mfrow = c(1,2))
plot(subGraph(mm$cliques[[1]], g1))
plot(subGraph(mm$cliques[[2]], g1))

## -----------------------------------------------------------------------------
if(require(microbenchmark)){
    microbenchmark(
        RBGL::maxClique(uG11),
        get_cliques(uG11),
        get_cliques(uG11m),
        get_cliques(uG11M),
        times=10) }

## -----------------------------------------------------------------------------
V <- 1:300
M <- 1:10
## Sparse graph
##
g1 <- randomGraph(V, M, 0.05)
length(edgeList(g1))
s <- c(NEL=object.size(g1), 
       dense=object.size(as(g1, "matrix")),
       sparse=object.size(as(g1, "dgCMatrix")))
s / max(s)
## More dense graph
##
g1 <- randomGraph(V, M, 0.5)
length(edgeList(g1))
s <- c(NEL=object.size(g1), 
       dense=object.size(as(g1, "matrix")),
       sparse=object.size(as(g1, "dgCMatrix")))
s / max(s)

## -----------------------------------------------------------------------------
args(querygraph)

## ----echo=FALSE--------------------------------------------------------------------
#rm(print.list)
options("width"=85)

