% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combnC-c.R
\name{combn_prim}
\alias{combn_prim}
\title{Generate All Combinations of n Elements Taken m at a Time}
\usage{
combn_prim(x, m, simplify = TRUE)
}
\arguments{
\item{x}{vector source for combinations, or integer n for x <-
seq(n).}

\item{m}{number of elements to choose.}

\item{simplify}{logical indicating if the result should be
simplified to a matrix; if FALSE, the function returns a list.}
}
\value{
A matrix or a list.
}
\description{
Generate all combinations of the elements of x taken m
    at a time.  If x is a positive integer, returns all
    combinations of the elements of seq(x) taken m at a time.
}
\note{
The combn_prim function is a simplified version of the combn
    function.  However, combn_prim is implemented in C and is
    considerably faster than combn.
}
\examples{

x <- letters[1:5]
m <- 3

combn(x, m)
combn_prim(x, m)

combn(m, m)
combn_prim(m, m)

combn(x, m, simplify=FALSE)
combn_prim(x, m, simplify=FALSE)

x <- letters[1:20]

\dontrun{
system.time({ for (i in 1:100) { combn_prim(x,m) }})
system.time({ for (i in 1:100) { combn(x,m) }})

system.time({ for (i in 1:100) { combn_prim(x,m, simplify=FALSE) }})
system.time({ for (i in 1:100) { combn(x,m, simplify=FALSE) }})
}

}
\seealso{
\code{\link{combn}}
}
\author{
P. T. Wallace and Søren Højsgaard
}
\keyword{utilities}
