% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_array_core_algebra_cpp.R
\name{array-algebra}
\alias{array-algebra}
\alias{ar_sum}
\alias{\%a+\%}
\alias{\%a-\%}
\alias{\%a*\%}
\alias{\%a/\%}
\alias{\%a/0\%}
\alias{ar_prod}
\alias{ar_prod_list}
\alias{ar_sum_list}
\alias{ar_add}
\alias{ar_subt}
\alias{ar_mult}
\alias{ar_div}
\alias{ar_div0}
\title{Array algebra}
\usage{
ar_sum(...)

ar_prod(...)

ar_prod_list(lst)

ar_sum_list(lst)

a1 \%a+\% a2

a1 \%a-\% a2

a1 \%a*\% a2

a1 \%a/\% a2

a1 \%a/0\% a2

ar_add(a1, a2)

ar_subt(a1, a2)

ar_mult(a1, a2)

ar_div(a1, a2)

ar_div0(a1, a2)
}
\arguments{
\item{lst}{List of arrays.}

\item{a, a1, a2, ...}{Arrays (with named dimnames)}
}
\description{
Addition, subtraction etc. of arrays
}
\examples{
hec <- HairEyeColor
a1 <- ar_marg(hec, c("Hair", "Eye"))
a2 <- ar_marg(hec, c("Hair", "Sex"))
a3 <- ar_marg(hec, c("Eye", "Sex"))

## Binary operations
a1 \%a+\% a2
a1 \%a-\% a2
a1 \%a*\% a2
a1 \%a/\% a2

ar_sum(a1, a2, a3)
ar_prod(a1, a2, a3)

}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
