% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpt.R
\name{cpt}
\alias{cpt}
\title{Create conditional probability table CPT.}
\usage{
cpt(names, levels, values, smooth = 0)
}
\arguments{
\item{names}{Names of variables defining table; either a character
vector or a right hand sided formula.}

\item{levels}{\enumerate{
\item a list with specification of the levels of the
factors in \code{names} or 2) a vector with number of levels of
the factors in \code{names}. See 'examples' below.
}}

\item{values}{values to go into the array.}

\item{smooth}{Should values be smoothed, see 'Details' below.}
}
\value{
An array.
}
\description{
Create conditional probability table CPT.
}
\examples{

universe <- list(gender=c('male', 'female'),
                 answer=c('yes', 'no'),
                 rain=c('yes', 'no'))
t1 <- cpt(c("gender", "answer"), levels=universe, values=1:4)
t1
t2 <- cpt(~gender:answer, levels=universe, values=1:4)
t2
t3 <- cpt(~gender:answer, c(2, 2), values=1:4)
t3
}
\keyword{utilities}
