% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evidence.R
\name{grain_evidence}
\alias{grain_evidence}
\alias{setEvidence}
\alias{retractEvidence}
\alias{absorbEvidence}
\alias{pEvidence}
\alias{getEvidence}
\alias{evidence}
\alias{evidence.grain}
\alias{evidence<-}
\alias{evidence<-.grain}
\title{Set, update and remove evidence.}
\usage{
setEvidence(
  object,
  nodes = NULL,
  states = NULL,
  evidence = NULL,
  nslist = NULL,
  propagate = TRUE,
  details = 0
)

retractEvidence(object, nodes = NULL, propagate = TRUE)

absorbEvidence(object, propagate = TRUE)

pEvidence(object)

getEvidence(object)

evidence(object)

\method{evidence}{grain}(object)

evidence(object) <- value

\method{evidence}{grain}(object) <- value
}
\arguments{
\item{object}{A "grain" object}

\item{nodes}{A vector of nodes; those nodes for which the
(conditional) distribution is requested.}

\item{states}{A vector of states (of the nodes given by 'nodes')}

\item{evidence}{An alternative way of specifying findings
(evidence), see examples below.}

\item{nslist}{deprecated}

\item{propagate}{Should the network be propagated?}

\item{details}{Debugging information}

\item{value}{The evidence in the form of a named list or an evidence-object.}
}
\value{
A list of tables with potentials.
}
\description{
Set, update and remove evidence.
}
\note{
\code{setEvidence()} is an improvement of \code{setFinding()}
(and as such \code{setFinding} is obsolete). Users are
recommended to use \code{setEvidence()} in the future.

\code{setEvidence()} allows to specification of "hard evidence" (specific
values for variables) and likelihood evidence (also known as virtual
evidence) for variables.

The syntax of \code{setEvidence()} may change in the future.
}
\examples{

data(chest_cpt)
chest.bn <- grain(compileCPT(chest_cpt))
chest.bn <- compile(chest.bn)

## 1) These two forms are identical
setEvidence(chest.bn, c("asia", "xray"), c("yes", "yes"))
setFinding(chest.bn, c("asia", "xray"), c("yes", "yes"))

## 2) Suppose we do not know with certainty whether a patient has
## recently been to Asia. We can then introduce a new variable
## "guess.asia" with "asia" as its only parent. Suppose
## p(guess.asia=yes|asia=yes)=.8 and p(guess.asia=yes|asia=no)=.1
## If the patient is e.g. unusually tanned we may set
## guess.asia=yes and propagate.
##
## This corresponds to modifying the model by the likelihood (0.8,
## 0.1) as

setEvidence(chest.bn, c("asia", "xray"), list(c(0.8, 0.1), "yes"))

## 3) Hence, the same result as in 1) can be obtained with
setEvidence(chest.bn, c("asia", "xray"), list(c(1, 0), "yes"))

## 4) An alternative specification using evidence is
setEvidence(chest.bn, evidence=list(asia=c(1, 0), xray="yes"))

}
\references{
Søren Højsgaard (2012). Graphical Independence Networks
with the gRain Package for R. Journal of Statistical Software,
46(10), 1-26.  \url{http://www.jstatsoft.org/v46/i10/}.
}
\seealso{
\code{\link{setFinding}}, \code{\link{getFinding}},
\code{\link{retractFinding}}, \code{\link{pFinding}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{models}
\keyword{utilities}
